<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class UpdateEnvCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'env:update {key} {value}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update .env file with new key-value pair';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $key = $this->argument('key');
        $value = $this->argument('value');
        
        $path = base_path('.env');
        
        if (file_exists($path)) {
            $content = file_get_contents($path);
            
            // If the key exists, replace its value
            if (preg_match("/^{$key}=.*/m", $content)) {
                $content = preg_replace("/^{$key}=.*/m", "{$key}={$value}", $content);
            } else {
                // If the key doesn't exist, add it
                $content .= "\n{$key}={$value}";
            }
            
            file_put_contents($path, $content);
            
            $this->info("{$key} has been updated with value: {$value}");
        } else {
            $this->error('.env file not found');
        }
    }
}
