<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class StationDataFilterMiddleware
{
    /**
     * Handle an incoming request.
     *
     * This middleware ensures that officers can only access data 
     * from their assigned police station (unless they are high-ranking officers)
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        if (!$user) {
            return $next($request);
        }

        // Share user's accessible data with all views
        view()->share('currentUser', $user);
        view()->share('userStation', $user->station);
        view()->share('hasMultiStationAccess', $user->hasMultiStationAccess());

        // Add station filtering to request for controllers to use
        $request->merge([
            'user_station_id' => $user->station_id,
            'has_multi_station_access' => $user->hasMultiStationAccess(),
            'accessible_station_ids' => $user->hasMultiStationAccess() 
                ? null // null means all stations
                : [$user->station_id] // array of accessible station IDs
        ]);

        return $next($request);
    }
}
