<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PoliceStation extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'code',
        'address',
        'city',
        'region',
        'phone',
        'email',
        'description',
        'is_headquarters',
        'is_active',
        'commander_id',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_headquarters' => 'boolean',
        'is_active' => 'boolean',
    ];

    /**
     * Get the commander of the police station.
     */
    public function commander(): BelongsTo
    {
        return $this->belongsTo(User::class, 'commander_id');
    }

    /**
     * Get the officers assigned to this police station.
     */
    public function officers(): HasMany
    {
        return $this->hasMany(User::class, 'station_id');
    }

    /**
     * Get the cases registered at this police station.
     */
    public function cases(): HasMany
    {
        // Using a placeholder for now as we haven't created the CaseRecord model yet
        // Will be implemented when we create the case management feature
        return $this->hasMany('App\Models\CaseRecord', 'station_id');
    }
}
