<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SuspectStatusUpdate extends Model
{
    use HasFactory, SoftDeletes;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'suspect_id',
        'officer_id',
        'update_type',
        'new_status',
        'description',
        'location',
        'update_date',
    ];
    
    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'new_status' => 'boolean',
        'update_date' => 'datetime',
    ];
    
    /**
     * Get the suspect that owns the status update.
     */
    public function suspect(): BelongsTo
    {
        return $this->belongsTo(CaseSuspect::class, 'suspect_id');
    }
    
    /**
     * Get the officer who created the update.
     */
    public function officer(): BelongsTo
    {
        return $this->belongsTo(User::class, 'officer_id');
    }
}
