<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\User;

class RankAuthorizationServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        //
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        // Define all rank-based permissions as gates
        $permissions = [
            // Station Management
            'manage-stations',
            'create-stations',
            
            // Officer Management
            'manage-officers',
            'create-officers',
            'batch-assign-officers',
            
            // Case Management
            'view-cases',
            'create-cases',
            'edit-cases',
            'delete-cases',
            'close-cases',
            
            // Evidence Management
            'manage-evidence',
            'transfer-evidence',
            'delete-evidence',
            
            // Statements
            'create-statements',
            'verify-statements',
            'edit-statements',
            
            // Suspects and Victims
            'manage-suspects',
            'manage-victims',
            'update-arrest-status',
            'update-charges',
            
            // Bail Management
            'manage-bail',
            'approve-bail',
            'bail-checkins',
            
            // Reports and Analytics
            'view-reports',
            'advanced-reports',
            'performance-reports',
            
            // System Settings
            'manage-settings',
            'manage-users',
            'system-backup',
        ];

        // Register each permission as a gate
        foreach ($permissions as $permission) {
            Gate::define($permission, function (User $user) use ($permission) {
                return $user->hasRankPermission($permission);
            });
        }
    }
}
