<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Title
    |--------------------------------------------------------------------------
    |
    | Here you can change the default title of your admin panel.
    |
    | For detailed instructions you can look the title section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'title' => 'Gambia Police CCMS',
    'title_prefix' => 'GPCMS | ',
    'title_postfix' => '',

    /*
    |--------------------------------------------------------------------------
    | Favicon
    |--------------------------------------------------------------------------
    |
    | Here you can activate the favicon.
    |
    | For detailed instructions you can look the favicon section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'use_ico_only' => false,
    'use_full_favicon' => false,

    /*
    |--------------------------------------------------------------------------
    | Google Fonts
    |--------------------------------------------------------------------------
    |
    | Here you can allow or not the use of external google fonts. Disabling the
    | google fonts may be useful if your admin panel internet access is
    | restricted somehow.
    |
    | For detailed instructions you can look the google fonts section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'google_fonts' => [
        'allowed' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Admin Panel Logo
    |--------------------------------------------------------------------------
    |
    | Here you can change the logo of your admin panel.
    |
    | For detailed instructions you can look the logo section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'logo' => '<b>Admin</b>LTE',
    'logo_img' => 'vendor/adminlte/dist/img/AdminLTELogo.png',
    'logo_img_class' => 'brand-image img-circle elevation-3',
    'logo_img_xl' => null,
    'logo_img_xl_class' => 'brand-image-xs',
    'logo_img_alt' => 'Admin Logo',

    /*
    |--------------------------------------------------------------------------
    | Authentication Logo
    |--------------------------------------------------------------------------
    |
    | Here you can setup an alternative logo to use on your login and register
    | screens. When disabled, the admin panel logo will be used instead.
    |
    | For detailed instructions you can look the auth logo section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'auth_logo' => [
        'enabled' => false,
        'img' => [
            'path' => 'vendor/adminlte/dist/img/AdminLTELogo.png',
            'alt' => 'Auth Logo',
            'class' => '',
            'width' => 50,
            'height' => 50,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Preloader Animation
    |--------------------------------------------------------------------------
    |
    | Here you can change the preloader animation configuration. Currently, two
    | modes are supported: 'fullscreen' for a fullscreen preloader animation
    | and 'cwrapper' to attach the preloader animation into the content-wrapper
    | element and avoid overlapping it with the sidebars and the top navbar.
    |
    | For detailed instructions you can look the preloader section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'preloader' => [
        'enabled' => true,
        'mode' => 'fullscreen',
        'img' => [
            'path' => 'img/gambia-police-logo.svg',
            'alt' => 'Gambia Police CCMS Logo',
            'effect' => 'animation__shake',
            'width' => 80,
            'height' => 80,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | User Menu
    |--------------------------------------------------------------------------
    |
    | Here you can activate and change the user menu.
    |
    | For detailed instructions you can look the user menu section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'usermenu_enabled' => true,
    'usermenu_header' => true,
    'usermenu_header_class' => 'bg-primary',
    'usermenu_image' => true,
    'usermenu_desc' => true,
    'usermenu_profile_url' => true,

    /*
    |--------------------------------------------------------------------------
    | Layout
    |--------------------------------------------------------------------------
    |
    | Here we change the layout of your admin panel.
    |
    | For detailed instructions you can look the layout section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'layout_topnav' => null,
    'layout_boxed' => null,
    'layout_fixed_sidebar' => true,
    'layout_fixed_navbar' => true,
    'layout_fixed_footer' => true,
    'layout_dark_mode' => null,

    /*
    |--------------------------------------------------------------------------
    | Authentication Views Classes
    |--------------------------------------------------------------------------
    |
    | Here you can change the look and behavior of the authentication views.
    |
    | For detailed instructions you can look the auth classes section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'classes_auth_card' => 'card-outline card-primary',
    'classes_auth_header' => 'bg-gradient-primary',
    'classes_auth_body' => '',
    'classes_auth_footer' => 'text-center',
    'classes_auth_icon' => 'fa-fw text-light',
    'classes_auth_btn' => 'btn-flat btn-primary',

    /*
    |--------------------------------------------------------------------------
    | Admin Panel Classes
    |--------------------------------------------------------------------------
    |
    | Here you can change the look and behavior of the admin panel.
    |
    | For detailed instructions you can look the admin panel classes here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'classes_body' => '',
    'classes_brand' => 'bg-primary',
    'classes_brand_text' => 'text-white',
    'classes_content_wrapper' => '',
    'classes_content_header' => 'text-dark',
    'classes_content' => '',
    'classes_sidebar' => 'sidebar-dark-primary elevation-4',
    'classes_sidebar_nav' => 'nav-child-indent nav-compact',
    'classes_topnav' => 'navbar-white navbar-light',
    'classes_topnav_nav' => 'navbar-expand',
    'classes_topnav_container' => 'container',

    /*
    |--------------------------------------------------------------------------
    | Sidebar
    |--------------------------------------------------------------------------
    |
    | Here we can modify the sidebar of the admin panel.
    |
    | For detailed instructions you can look the sidebar section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'sidebar_mini' => 'lg',
    'sidebar_collapse' => false,
    'sidebar_collapse_auto_size' => false,
    'sidebar_collapse_remember' => false,
    'sidebar_collapse_remember_no_transition' => true,
    'sidebar_scrollbar_theme' => 'os-theme-light',
    'sidebar_scrollbar_auto_hide' => 'l',
    'sidebar_nav_accordion' => true,
    'sidebar_nav_animation_speed' => 300,

    /*
    |--------------------------------------------------------------------------
    | Control Sidebar (Right Sidebar)
    |--------------------------------------------------------------------------
    |
    | Here we can modify the right sidebar aka control sidebar of the admin panel.
    |
    | For detailed instructions you can look the right sidebar section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'right_sidebar' => false,
    'right_sidebar_icon' => 'fas fa-cogs',
    'right_sidebar_theme' => 'dark',
    'right_sidebar_slide' => true,
    'right_sidebar_push' => true,
    'right_sidebar_scrollbar_theme' => 'os-theme-light',
    'right_sidebar_scrollbar_auto_hide' => 'l',

    /*
    |--------------------------------------------------------------------------
    | URLs
    |--------------------------------------------------------------------------
    |
    | Here we can modify the url settings of the admin panel.
    |
    | For detailed instructions you can look the urls section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'use_route_url' => false,
    'dashboard_url' => 'home',
    'logout_url' => 'logout',
    'login_url' => 'login',
    'register_url' => 'register',
    'password_reset_url' => 'password/reset',
    'password_email_url' => 'password/email',
    'profile_url' => false,
    'disable_darkmode_routes' => false,

    /*
    |--------------------------------------------------------------------------
    | Laravel Asset Bundling
    |--------------------------------------------------------------------------
    |
    | Here we can enable the Laravel Asset Bundling option for the admin panel.
    | Currently, the next modes are supported: 'mix', 'vite' and 'vite_js_only'.
    | When using 'vite_js_only', it's expected that your CSS is imported using
    | JavaScript. Typically, in your application's 'resources/js/app.js' file.
    | If you are not using any of these, leave it as 'false'.
    |
    | For detailed instructions you can look the asset bundling section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Other-Configuration
    |
    */

    'laravel_asset_bundling' => false,
    'laravel_css_path' => 'css/app.css',
    'laravel_js_path' => 'js/app.js',

    /*
    |--------------------------------------------------------------------------
    | Menu Items
    |--------------------------------------------------------------------------
    |
    | Here we can modify the sidebar/top navigation of the admin panel.
    |
    | For detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Menu-Configuration
    |
    */

    'menu' => [
        // Navbar items:
        [
            'type' => 'navbar-search',
            'text' => 'search',
            'topnav_right' => true,
        ],
        [
            'type' => 'fullscreen-widget',
            'topnav_right' => true,
        ],

        // Sidebar items:
        [
            'type' => 'sidebar-menu-search',
            'text' => 'search',
        ],
        [
            'text' => 'Dashboard',
            'url' => 'dashboard',
            'icon' => 'fas fa-fw fa-tachometer-alt',
        ],
        ['header' => 'HEADQUARTERS MANAGEMENT'],
        [
            'text' => 'Police Stations',
            'icon' => 'fas fa-fw fa-building',
            'can' => 'manage-stations',
            'submenu' => [
                [
                    'text' => 'All Stations',
                    'url' => 'stations',
                    'icon' => 'fas fa-fw fa-list',
                    'can' => 'manage-stations',
                ],
                [
                    'text' => 'Add New Station',
                    'url' => 'stations/create',
                    'icon' => 'fas fa-fw fa-plus',
                    'can' => 'create-stations',
                ],
            ],
        ],
        [
            'text' => 'Officer Management',
            'icon' => 'fas fa-fw fa-user-shield',
            'can' => 'manage-officers',
            'submenu' => [
                [
                    'text' => 'All Officers',
                    'url' => 'officers',
                    'icon' => 'fas fa-fw fa-users',
                    'can' => 'manage-officers',
                ],
                [
                    'text' => 'Add New Officer',
                    'url' => 'officers/create',
                    'icon' => 'fas fa-fw fa-user-plus',
                    'can' => 'create-officers',
                ],
                [
                    'text' => 'Batch Assign',
                    'url' => 'officers-assign',
                    'icon' => 'fas fa-fw fa-users-cog',
                    'can' => 'batch-assign-officers',
                ],
            ],
        ],
        ['header' => 'CASE MANAGEMENT'],
        [
            'text' => 'Cases',
            'icon' => 'fas fa-fw fa-folder',
            'can' => 'view-cases',
            'submenu' => [
                [
                    'text' => 'All Cases',
                    'url' => 'cases',
                    'icon' => 'fas fa-fw fa-folder-open',
                    'can' => 'view-cases',
                ],
                [
                    'text' => 'Add New Case',
                    'url' => 'cases/create',
                    'icon' => 'fas fa-fw fa-plus',
                    'can' => 'create-cases',
                ],
                [
                    'text' => 'Open Cases',
                    'url' => 'cases?status=open',
                    'icon' => 'fas fa-fw fa-lock-open',
                    'can' => 'view-cases',
                ],
                [
                    'text' => 'Under Investigation',
                    'url' => 'cases?status=under_investigation',
                    'icon' => 'fas fa-fw fa-search',
                    'can' => 'view-cases',
                ],
                [
                    'text' => 'Pending Review',
                    'url' => 'cases?status=pending_review',
                    'icon' => 'fas fa-fw fa-clock',
                    'can' => 'view-cases',
                ],
                [
                    'text' => 'Closed Cases',
                    'url' => 'cases?status=closed',
                    'icon' => 'fas fa-fw fa-lock',
                    'can' => 'view-cases',
                ],
            ],
        ],
        [
            'text' => 'Case Components',
            'icon' => 'fas fa-fw fa-clipboard-list',
            'can' => 'view-cases',
            'submenu' => [
                [
                    'text' => 'Statements',
                    'url' => 'case-statements',
                    'icon' => 'fas fa-fw fa-comment',
                    'can' => 'create-statements',
                ],
                [
                    'text' => 'Evidence',
                    'url' => 'case-evidences',
                    'icon' => 'fas fa-fw fa-fingerprint',
                    'can' => 'manage-evidence',
                ],
                [
                    'text' => 'Evidence Transfers',
                    'url' => 'evidence-transfers',
                    'icon' => 'fas fa-fw fa-exchange-alt',
                    'can' => 'transfer-evidence',
                ],
                [
                    'text' => 'Suspects',
                    'url' => 'case-suspects',
                    'icon' => 'fas fa-fw fa-user-secret',
                    'can' => 'manage-suspects',
                ],
                [
                    'text' => 'Victims',
                    'url' => 'case-victims',
                    'icon' => 'fas fa-fw fa-user-injured',
                    'can' => 'manage-victims',
                ],
                [
                    'text' => 'Case Updates',
                    'url' => 'case-updates',
                    'icon' => 'fas fa-fw fa-history',
                    'can' => 'view-cases',
                ],
            ],
        ],
        [
            'text' => 'Case Reports',
            'icon' => 'fas fa-fw fa-chart-bar',
            'can' => 'view-reports',
            'submenu' => [
                [
                    'text' => 'Case Statistics',
                    'url' => 'case-statistics',
                    'icon' => 'fas fa-fw fa-chart-pie',
                    'can' => 'view-reports',
                ],
                [
                    'text' => 'Case by Station',
                    'url' => 'case-by-station',
                    'icon' => 'fas fa-fw fa-building',
                    'can' => 'view-reports',
                ],
                [
                    'text' => 'Case by Officer',
                    'url' => 'case-by-officer',
                    'icon' => 'fas fa-fw fa-user-tie',
                    'can' => 'view-reports',
                ],
                [
                    'text' => 'Case by Crime Type',
                    'url' => 'case-by-crime',
                    'icon' => 'fas fa-fw fa-exclamation-triangle',
                    'can' => 'view-reports',
                ],
            ],
        ],
        [
            'text' => 'Evidence Management',
            'url' => 'evidence',
            'icon' => 'fas fa-fw fa-camera',
            'can' => 'manage-evidence',
        ],
        ['header' => 'BAIL MANAGEMENT'],
        [
            'text' => 'Bail Applications',
            'icon' => 'fas fa-fw fa-file-signature',
            'can' => 'manage-bail',
            'submenu' => [
                [
                    'text' => 'All Applications',
                    'url' => 'bail',
                    'icon' => 'fas fa-fw fa-list-alt',
                    'can' => 'manage-bail',
                ],
                [
                    'text' => 'New Application',
                    'url' => 'bail/create',
                    'icon' => 'fas fa-fw fa-plus-square',
                    'can' => 'manage-bail',
                ],
                [
                    'text' => 'Pending Approval',
                    'url' => 'bail?status=pending',
                    'icon' => 'fas fa-fw fa-clock',
                    'can' => 'approve-bail',
                ],
            ],
        ],
        [
            'text' => 'Bail Check-ins',
            'icon' => 'fas fa-fw fa-calendar-check',
            'can' => 'bail-checkins',
            'submenu' => [
                [
                    'text' => 'All Check-ins',
                    'url' => 'bail-checkins',
                    'icon' => 'fas fa-fw fa-list',
                    'can' => 'bail-checkins',
                ],
                [
                    'text' => 'Today\'s Check-ins',
                    'url' => 'bail-checkins-today',
                    'icon' => 'fas fa-fw fa-calendar-day',
                    'can' => 'bail-checkins',
                ],
                [
                    'text' => 'New Check-in',
                    'url' => 'bail-checkins/create',
                    'icon' => 'fas fa-fw fa-plus',
                    'can' => 'bail-checkins',
                ],
                [
                    'text' => 'Reporting Statistics',
                    'url' => 'bail-checkins-stats',
                    'icon' => 'fas fa-fw fa-chart-line',
                    'can' => 'view-reports',
                ],
            ],
        ],
        ['header' => 'REPORTS & ANALYTICS'],
        [
            'text' => 'Crime Statistics',
            'url' => 'reports/statistics',
            'icon' => 'fas fa-fw fa-chart-bar',
            'can' => 'view-reports',
        ],
        [
            'text' => 'Officer Performance',
            'url' => 'reports/performance',
            'icon' => 'fas fa-fw fa-chart-line',
            'can' => 'performance-reports',
        ],
        [
            'text' => 'Station Reports',
            'url' => 'reports/stations',
            'icon' => 'fas fa-fw fa-file-alt',
            'can' => 'advanced-reports',
        ],
        ['header' => 'USER SETTINGS'],
        
        ['header' => 'SYSTEM SETTINGS'],
        [
            'text' => 'Settings',
            'icon' => 'fas fa-fw fa-cogs',
            'can' => 'manage-settings',
            'submenu' => [
                [
                    'text' => 'General Settings',
                    'url'  => 'settings/general',
                    'icon' => 'fas fa-fw fa-sliders-h',
                    'can' => 'manage-settings',
                ],
                [
                    'text' => 'Backup & Restore',
                    'url'  => 'settings/backup',
                    'icon' => 'fas fa-fw fa-database',
                    'can' => 'system-backup',
                ],
                [
                    'text' => 'System Logs',
                    'url'  => 'settings/logs',
                    'icon' => 'fas fa-fw fa-clipboard-list',
                    'can' => 'manage-settings',
                ],
                [
                    'text' => 'Roles & Permissions',
                    'url'  => 'settings/roles',
                    'icon' => 'fas fa-fw fa-user-lock',
                    'can' => 'manage-users',
                ],
                [
                    'text' => 'API Configuration',
                    'url'  => 'settings/api',
                    'icon' => 'fas fa-fw fa-plug',
                    'can' => 'manage-settings',
                ],
            ],
        ],
        [
            'text' => 'Profile',
            'url' => 'profile',
            'icon' => 'fas fa-fw fa-user',
        ],
        [
            'text' => 'Change Password',
            'url' => 'profile/password',
            'icon' => 'fas fa-fw fa-lock',
        ],
        ['header' => 'SYSTEM'],
        [
            'text' => 'User Management',
            'url' => 'users',
            'icon' => 'fas fa-fw fa-users-cog',
            'can' => 'manage-users',
        ],
        [
            'text' => 'System Settings',
            'url' => 'settings',
            'icon' => 'fas fa-fw fa-cogs',
            'can' => 'manage-settings',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Menu Filters
    |--------------------------------------------------------------------------
    |
    | Here we can modify the menu filters of the admin panel.
    |
    | For detailed instructions you can look the menu filters section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Menu-Configuration
    |
    */

    'filters' => [
        JeroenNoten\LaravelAdminLte\Menu\Filters\GateFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\HrefFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\SearchFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\ActiveFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\ClassesFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\LangFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\DataFilter::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Plugins Initialization
    |--------------------------------------------------------------------------
    |
    | Here we can modify the plugins used inside the admin panel.
    |
    | For detailed instructions you can look the plugins section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Plugins-Configuration
    |
    */

    'plugins' => [
        'Datatables' => [
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js',
                ],
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js',
                ],
                [
                    'type' => 'css',
                    'asset' => false,
                    'location' => '//cdn.datatables.net/1.10.19/css/dataTables.bootstrap4.min.css',
                ],
            ],
        ],
        'Select2' => [
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js',
                ],
                [
                    'type' => 'css',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.css',
                ],
            ],
        ],
        'Chartjs' => [
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.0/Chart.bundle.min.js',
                ],
            ],
        ],
        'Sweetalert2' => [
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdn.jsdelivr.net/npm/sweetalert2@8',
                ],
            ],
        ],
        'Pace' => [
            'active' => false,
            'files' => [
                [
                    'type' => 'css',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/pace/1.0.2/themes/blue/pace-theme-center-radar.min.css',
                ],
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/pace/1.0.2/pace.min.js',
                ],
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | IFrame
    |--------------------------------------------------------------------------
    |
    | Here we change the IFrame mode configuration. Note these changes will
    | only apply to the view that extends and enable the IFrame mode.
    |
    | For detailed instructions you can look the iframe mode section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/IFrame-Mode-Configuration
    |
    */

    'iframe' => [
        'default_tab' => [
            'url' => null,
            'title' => null,
        ],
        'buttons' => [
            'close' => true,
            'close_all' => true,
            'close_all_other' => true,
            'scroll_left' => true,
            'scroll_right' => true,
            'fullscreen' => true,
        ],
        'options' => [
            'loading_screen' => 1000,
            'auto_show_new_tab' => true,
            'use_navbar_items' => true,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Livewire
    |--------------------------------------------------------------------------
    |
    | Here we can enable the Livewire support.
    |
    | For detailed instructions you can look the livewire here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Other-Configuration
    |
    */

    'livewire' => false,
];
