<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('is_officer')->default(false)->after('remember_token');
            $table->string('rank')->nullable()->after('is_officer');
            $table->string('badge_number')->nullable()->after('rank');
            $table->foreignId('station_id')->nullable()->after('badge_number')
                ->constrained('police_stations')->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['station_id']);
            $table->dropColumn(['is_officer', 'rank', 'badge_number', 'station_id']);
        });
    }
};
