<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cases', function (Blueprint $table) {
            $table->id();
            $table->string('case_number')->unique();
            $table->string('title');
            $table->text('description');
            $table->foreignId('station_id')->constrained('police_stations');
            $table->foreignId('reporting_officer_id')->constrained('users');
            $table->foreignId('lead_investigator_id')->nullable()->constrained('users');
            $table->date('incident_date');
            $table->time('incident_time')->nullable();
            $table->string('incident_location');
            $table->string('incident_coordinates')->nullable();
            $table->string('crime_type');
            $table->string('crime_category');
            $table->enum('status', ['open', 'under_investigation', 'pending_review', 'closed', 'reopened', 'archived']);
            $table->enum('priority', ['low', 'medium', 'high', 'critical'])->default('medium');
            $table->date('reported_date');
            $table->text('action_taken')->nullable();
            $table->text('recommendations')->nullable();
            $table->date('closed_date')->nullable();
            $table->string('closed_by')->nullable();
            $table->text('closing_remarks')->nullable();
            $table->boolean('is_sensitive')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cases');
    }
};
