<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('case_statements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('case_id')->constrained('cases')->onDelete('cascade');
            $table->enum('statement_type', ['victim', 'witness', 'suspect', 'officer', 'expert']);
            $table->string('given_by_name');
            $table->string('given_by_contact')->nullable();
            $table->string('given_by_address')->nullable();
            $table->string('given_by_id_type')->nullable(); // National ID, Passport, etc.
            $table->string('given_by_id_number')->nullable();
            $table->foreignId('recorded_by_officer_id')->constrained('users');
            $table->dateTime('statement_date');
            $table->text('statement_content');
            $table->string('location_taken');
            $table->boolean('is_sworn')->default(false);
            $table->boolean('is_signed')->default(false);
            $table->string('signature_file_path')->nullable();
            $table->string('audio_recording_path')->nullable();
            $table->text('officer_remarks')->nullable();
            $table->boolean('is_verified')->default(false);
            $table->foreignId('verified_by_officer_id')->nullable()->constrained('users');
            $table->dateTime('verified_at')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('case_statements');
    }
};
