<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('case_evidence', function (Blueprint $table) {
            $table->id();
            $table->foreignId('case_id')->constrained('cases')->onDelete('cascade');
            $table->string('evidence_number')->unique();
            $table->string('name');
            $table->text('description');
            $table->enum('type', ['physical', 'digital', 'documentary', 'testimonial', 'forensic', 'other']);
            $table->string('subtype')->nullable(); // e.g., weapon, document, photo, video, etc.
            $table->dateTime('collection_date');
            $table->string('collection_location');
            $table->foreignId('collected_by_officer_id')->constrained('users');
            $table->string('storage_location')->nullable();
            $table->string('chain_of_custody_status');
            $table->text('chain_of_custody_notes')->nullable();
            $table->boolean('is_sensitive')->default(false);
            $table->string('file_path')->nullable(); // For digital evidence
            $table->string('photo_path')->nullable(); // Photo of physical evidence
            $table->text('analysis_results')->nullable();
            $table->foreignId('analyzed_by_officer_id')->nullable()->constrained('users');
            $table->dateTime('analyzed_at')->nullable();
            $table->boolean('is_admissible')->default(true);
            $table->text('admissibility_notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('case_evidence');
    }
};
