<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('case_suspects', function (Blueprint $table) {
            $table->id();
            $table->foreignId('case_id')->constrained('cases')->onDelete('cascade');
            $table->string('full_name');
            $table->string('alias')->nullable();
            $table->string('gender')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->integer('age')->nullable();
            $table->string('nationality')->nullable();
            $table->string('id_type')->nullable(); // National ID, Passport, etc.
            $table->string('id_number')->nullable();
            $table->string('address')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->text('physical_description')->nullable();
            $table->string('photo_path')->nullable();
            $table->text('relationship_to_victim')->nullable();
            $table->text('alleged_involvement')->nullable();
            $table->boolean('is_arrested')->default(false);
            $table->dateTime('arrest_date')->nullable();
            $table->string('arrest_location')->nullable();
            $table->foreignId('arrested_by_officer_id')->nullable()->constrained('users');
            $table->boolean('is_charged')->default(false);
            $table->string('charges')->nullable();
            $table->dateTime('charge_date')->nullable();
            $table->boolean('is_in_custody')->default(false);
            $table->string('custody_location')->nullable();
            $table->text('criminal_history')->nullable();
            $table->text('officer_notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('case_suspects');
    }
};
