<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('case_victims', function (Blueprint $table) {
            $table->id();
            $table->foreignId('case_id')->constrained('cases')->onDelete('cascade');
            $table->string('full_name');
            $table->string('gender')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->integer('age')->nullable();
            $table->string('nationality')->nullable();
            $table->string('id_type')->nullable(); // National ID, Passport, etc.
            $table->string('id_number')->nullable();
            $table->string('address')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('occupation')->nullable();
            $table->text('physical_description')->nullable();
            $table->string('photo_path')->nullable();
            $table->text('injuries_sustained')->nullable();
            $table->text('medical_report')->nullable();
            $table->string('medical_facility')->nullable();
            $table->text('relationship_to_suspect')->nullable();
            $table->boolean('is_vulnerable')->default(false); // Child, elderly, disabled, etc.
            $table->text('vulnerability_details')->nullable();
            $table->boolean('requires_protection')->default(false);
            $table->text('protection_details')->nullable();
            $table->boolean('is_deceased')->default(false);
            $table->dateTime('time_of_death')->nullable();
            $table->string('cause_of_death')->nullable();
            $table->text('officer_notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('case_victims');
    }
};
