<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('case_updates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('case_id')->constrained('cases')->onDelete('cascade');
            $table->string('update_type'); // Investigation, Evidence, Arrest, Interview, Court, etc.
            $table->text('description');
            $table->foreignId('officer_id')->constrained('users');
            $table->dateTime('update_date');
            $table->string('location')->nullable();
            $table->text('action_taken')->nullable();
            $table->text('results')->nullable();
            $table->text('next_steps')->nullable();
            $table->boolean('is_significant')->default(false);
            $table->boolean('requires_followup')->default(false);
            $table->dateTime('followup_date')->nullable();
            $table->string('followup_action')->nullable();
            $table->boolean('is_internal_only')->default(false);
            $table->string('attachment_path')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('case_updates');
    }
};
