<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('case_victims', function (Blueprint $table) {
            // Add missing fields from our views
            $table->enum('victim_type', ['individual', 'organization'])->default('individual')->after('case_id');
            
            // Organization-specific fields
            $table->string('organization_name')->nullable()->after('full_name');
            $table->string('organization_type')->nullable()->after('organization_name');
            $table->string('registration_number')->nullable()->after('organization_type');
            $table->string('contact_person_name')->nullable()->after('registration_number');
            $table->string('contact_person_role')->nullable()->after('contact_person_name');
            
            // Incident details
            $table->dateTime('incident_date')->nullable()->after('protection_details');
            $table->string('incident_location')->nullable()->after('incident_date');
            $table->text('incident_description')->nullable()->after('incident_location');
            
            // Injury status
            $table->enum('injury_status', ['none', 'minor', 'moderate', 'severe', 'critical', 'deceased'])
                ->default('none')
                ->after('injuries_sustained');
                
            // Evidence photos (JSON array of file paths)
            $table->json('evidence_photos')->nullable()->after('photo_path');
            
            // Additional fields
            $table->foreignId('created_by_user_id')->nullable()->constrained('users')->after('officer_notes');
            $table->foreignId('updated_by_user_id')->nullable()->constrained('users')->after('created_by_user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('case_victims', function (Blueprint $table) {
            $table->dropColumn([
                'victim_type',
                'organization_name',
                'organization_type',
                'registration_number',
                'contact_person_name',
                'contact_person_role',
                'incident_date',
                'incident_location',
                'incident_description',
                'injury_status',
                'evidence_photos'
            ]);
            
            $table->dropConstrainedForeignId('created_by_user_id');
            $table->dropConstrainedForeignId('updated_by_user_id');
        });
    }
};
