<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('evidence_transfers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('evidence_id')->constrained('case_evidences')->onDelete('cascade');
            $table->string('from_person');
            $table->string('to_person');
            $table->date('transfer_date');
            $table->time('transfer_time');
            $table->enum('reason', [
                'analysis', 'storage', 'court', 'return', 'disposal', 'other'
            ])->default('other');
            $table->text('notes')->nullable();
            $table->foreignId('recorded_by_user_id')->nullable()->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('evidence_transfers');
    }
};
