<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('evidence', function (Blueprint $table) {
            $table->id();
            $table->string('tag_number')->unique();
            $table->string('evidence_type');
            $table->text('description');
            $table->string('status')->default('in_custody');
            $table->string('condition')->nullable();
            $table->string('location')->nullable();
            $table->string('storage_location')->nullable();
            $table->dateTime('collection_date')->nullable();
            $table->string('collection_location')->nullable();
            $table->text('collection_notes')->nullable();
            $table->foreignId('collected_by_officer_id')->nullable()->constrained('users');
            $table->foreignId('custodian')->nullable()->constrained('users');
            $table->foreignId('analyzed_by_officer_id')->nullable()->constrained('users');
            $table->dateTime('analysis_date')->nullable();
            $table->text('analysis_results')->nullable();
            $table->json('photos')->nullable();
            $table->json('documents')->nullable();
            $table->json('chain_of_custody')->nullable();
            $table->foreignId('created_by_user_id')->nullable()->constrained('users');
            $table->foreignId('updated_by_user_id')->nullable()->constrained('users');
            $table->foreignId('case_id')->nullable()->constrained('cases');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('evidence');
    }
};
