<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bail_applications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('case_id')->nullable()->constrained('cases')->nullOnDelete();
            $table->foreignId('suspect_id')->nullable();
            $table->foreign('suspect_id')->references('id')->on('case_suspects')->nullOnDelete();
            $table->string('application_number')->unique();
            $table->date('application_date');
            $table->enum('status', ['pending', 'approved', 'rejected', 'revoked'])->default('pending');
            $table->date('approval_date')->nullable();
            $table->date('expiry_date')->nullable();
            $table->decimal('amount', 12, 2)->nullable();
            $table->string('surety_name')->nullable();
            $table->string('surety_contact')->nullable();
            $table->string('surety_address')->nullable();
            $table->string('surety_relationship')->nullable();
            $table->string('surety_id_type')->nullable();
            $table->string('surety_id_number')->nullable();
            $table->text('reason')->nullable();
            $table->text('notes')->nullable();
            $table->foreignId('approved_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bail_applications');
    }
};
