<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bail_conditions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bail_application_id')->constrained('bail_applications')->cascadeOnDelete();
            $table->string('condition_type');
            $table->text('description');
            $table->boolean('is_fulfilled')->default(false);
            $table->date('fulfillment_date')->nullable();
            $table->text('fulfillment_notes')->nullable();
            $table->foreignId('verified_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bail_conditions');
    }
};
