<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('suspect_status_updates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('suspect_id')->constrained('case_suspects')->onDelete('cascade');
            $table->foreignId('officer_id')->nullable()->constrained('users')->onDelete('set null');
            $table->enum('update_type', ['arrest', 'charge', 'custody', 'other']);
            $table->boolean('new_status')->nullable();
            $table->text('description')->nullable();
            $table->string('location')->nullable();
            $table->timestamp('update_date')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('suspect_status_updates');
    }
};
