<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bail_checkins', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bail_application_id')->constrained('bail_applications')->cascadeOnDelete();
            $table->foreignId('suspect_id')->nullable();
            $table->foreign('suspect_id')->references('id')->on('case_suspects')->nullOnDelete();
            $table->foreignId('police_station_id')->nullable()->constrained('police_stations')->nullOnDelete();
            $table->dateTime('checkin_time');
            $table->dateTime('scheduled_time')->nullable();
            $table->boolean('is_present')->default(false);
            $table->enum('status', ['scheduled', 'present', 'missed', 'excused'])->default('scheduled');
            $table->text('notes')->nullable();
            $table->foreignId('recorded_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bail_checkins');
    }
};
