<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bail_conditions', function (Blueprint $table) {
            $table->boolean('requires_reporting')->default(false)->after('description');
            $table->foreignId('police_station_id')->nullable()->after('requires_reporting')->constrained('police_stations')->nullOnDelete();
            $table->enum('reporting_frequency', ['daily', 'weekly', 'biweekly', 'monthly', 'custom'])->nullable()->after('police_station_id');
            $table->string('reporting_days')->nullable()->after('reporting_frequency'); // JSON array or comma-separated days of week
            $table->time('reporting_time_start')->nullable()->after('reporting_days');
            $table->time('reporting_time_end')->nullable()->after('reporting_time_start');
            $table->date('reporting_start_date')->nullable()->after('reporting_time_end');
            $table->date('reporting_end_date')->nullable()->after('reporting_start_date');
            $table->integer('total_required_checkins')->nullable()->after('reporting_end_date');
            $table->integer('completed_checkins')->default(0)->after('total_required_checkins');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bail_conditions', function (Blueprint $table) {
            $table->dropForeign(['police_station_id']);
            $table->dropColumn([
                'requires_reporting',
                'police_station_id',
                'reporting_frequency',
                'reporting_days',
                'reporting_time_start',
                'reporting_time_end',
                'reporting_start_date',
                'reporting_end_date',
                'total_required_checkins',
                'completed_checkins'
            ]);
        });
    }
};
