<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\CaseRecord;
use App\Models\User;
use App\Models\PoliceStation;
use Carbon\Carbon;

class CaseRecordSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $officers = User::where('is_officer', true)->get();
        $stations = PoliceStation::all();
        
        $cases = [
            [
                'title' => 'Armed Robbery at Kairaba Avenue',
                'description' => 'Armed robbery incident at a supermarket on Kairaba Avenue. Two masked men with firearms stole cash and valuables.',
                'crime_type' => 'robbery',
                'crime_category' => 'violent',
                'status' => 'open',
                'priority' => 'high',
                'location' => 'Kairaba Avenue, Serrekunda',
                'report_date' => Carbon::now()->subDays(5)->format('Y-m-d'),
                'incident_date' => Carbon::now()->subDays(6)->format('Y-m-d'),
                'reporter_name' => 'Alieu Jallow',
                'reporter_contact' => '+2207654321',
                'reporter_address' => 'Pipeline, Serrekunda',
                'reporter_relationship' => 'victim',
            ],
            [
                'title' => 'Vehicle Theft at Senegambia',
                'description' => 'Toyota Corolla stolen from the parking lot of Senegambia Beach Hotel. Vehicle registration number: BJL 1234.',
                'crime_type' => 'theft',
                'crime_category' => 'property',
                'status' => 'under_investigation',
                'priority' => 'medium',
                'location' => 'Senegambia Beach Hotel, Kololi',
                'report_date' => Carbon::now()->subDays(3)->format('Y-m-d'),
                'incident_date' => Carbon::now()->subDays(3)->format('Y-m-d'),
                'reporter_name' => 'Omar Sowe',
                'reporter_contact' => '+2207123456',
                'reporter_address' => 'Kololi, Kanifing Municipality',
                'reporter_relationship' => 'victim',
            ],
            [
                'title' => 'Assault at Westfield Junction',
                'description' => 'Physical assault incident at Westfield Junction. Victim sustained injuries and was taken to Serrekunda General Hospital.',
                'crime_type' => 'assault',
                'crime_category' => 'violent',
                'status' => 'open',
                'priority' => 'medium',
                'location' => 'Westfield Junction, Serrekunda',
                'report_date' => Carbon::now()->subDays(2)->format('Y-m-d'),
                'incident_date' => Carbon::now()->subDays(2)->format('Y-m-d'),
                'reporter_name' => 'Fatou Camara',
                'reporter_contact' => '+2207987654',
                'reporter_address' => 'Latrikunda, Serrekunda',
                'reporter_relationship' => 'witness',
            ],
            [
                'title' => 'Burglary at Fajara Residence',
                'description' => 'Residential burglary at Fajara. Electronics and jewelry stolen while homeowners were away.',
                'crime_type' => 'burglary',
                'crime_category' => 'property',
                'status' => 'under_investigation',
                'priority' => 'medium',
                'location' => 'Fajara, Bakau',
                'report_date' => Carbon::now()->subDays(7)->format('Y-m-d'),
                'incident_date' => Carbon::now()->subDays(8)->format('Y-m-d'),
                'reporter_name' => 'James Johnson',
                'reporter_contact' => '+2207111222',
                'reporter_address' => 'Fajara, Bakau',
                'reporter_relationship' => 'victim',
            ],
            [
                'title' => 'Drug Possession at Banjul Ferry Terminal',
                'description' => 'Suspect apprehended with suspected cannabis at the Banjul Ferry Terminal during routine search.',
                'crime_type' => 'drugs',
                'crime_category' => 'narcotics',
                'status' => 'pending_review',
                'priority' => 'medium',
                'location' => 'Banjul Ferry Terminal, Banjul',
                'report_date' => Carbon::now()->subDay()->format('Y-m-d'),
                'incident_date' => Carbon::now()->subDay()->format('Y-m-d'),
                'reporter_name' => 'Officer Lamin Bojang',
                'reporter_contact' => '+2207333444',
                'reporter_address' => 'Banjul Police Station',
                'reporter_relationship' => 'officer',
            ],
        ];
        
        foreach ($cases as $index => $case) {
            $officerIndex = $index % count($officers->toArray());
            $stationIndex = $index % count($stations->toArray());
            
            $caseNumber = 'GPCMS-' . date('Y') . '-' . str_pad($index + 1, 4, '0', STR_PAD_LEFT);
            
            // Check if case already exists
            $existingCase = CaseRecord::where('case_number', $caseNumber)->first();
            
            if (!$existingCase) {
                CaseRecord::create([
                    'case_number' => $caseNumber,
                    'title' => $case['title'],
                    'description' => $case['description'],
                    'crime_type' => $case['crime_type'],
                    'crime_category' => $case['crime_category'],
                    'status' => $case['status'],
                    'priority' => $case['priority'],
                    'incident_location' => $case['location'],
                    'reported_date' => $case['report_date'],
                    'incident_date' => $case['incident_date'],
                    'action_taken' => 'Initial report filed. Investigation pending.',
                    'reporting_officer_id' => $officers[$officerIndex]->id,
                    'lead_investigator_id' => $officers[$officerIndex]->id,
                    'station_id' => $stations[$stationIndex]->id,
                ]);
            }
        }
    }
}
