<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\CaseSuspect;
use App\Models\CaseRecord;
use App\Models\User;
use Carbon\Carbon;

class CaseSuspectSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $cases = CaseRecord::all();
        $officers = User::where('is_officer', true)->get();
        
        $suspects = [
            [
                'first_name' => 'Modou',
                'last_name' => 'Sanneh',
                'alias' => 'Mo',
                'gender' => 'male',
                'age' => 28,
                'id_type' => 'national_id',
                'id_number' => 'GN987654',
                'address' => 'Bundung, Serrekunda',
                'phone' => '+2207444555',
                'nationality' => 'Gambian',
                'height' => 175,
                'weight' => 70,
                'eye_color' => 'brown',
                'hair_color' => 'black',
                'distinguishing_features' => 'Scar on right cheek',
                'status' => 'wanted',
                'is_arrested' => false,
                'arrest_date' => null,
                'arrest_location' => null,
                'arresting_officer' => null,
                'notes' => 'Suspect identified through CCTV footage. Known to frequent Serrekunda market area.',
            ],
            [
                'first_name' => 'Lamin',
                'last_name' => 'Touray',
                'alias' => 'LT',
                'gender' => 'male',
                'age' => 32,
                'id_type' => 'national_id',
                'id_number' => 'GN456123',
                'address' => 'Bakau New Town, Bakau',
                'phone' => '+2207666777',
                'nationality' => 'Gambian',
                'height' => 180,
                'weight' => 85,
                'eye_color' => 'brown',
                'hair_color' => 'black',
                'distinguishing_features' => 'Tattoo on left arm',
                'status' => 'arrested',
                'is_arrested' => true,
                'arrest_date' => Carbon::now()->subDays(1)->format('Y-m-d'),
                'arrest_location' => 'Banjul Ferry Terminal, Banjul',
                'arresting_officer' => 'Officer Lamin Bojang',
                'notes' => 'Arrested during routine search at ferry terminal. Found with suspected cannabis.',
            ],
            [
                'first_name' => 'Ousman',
                'last_name' => 'Jobe',
                'alias' => 'Ous',
                'gender' => 'male',
                'age' => 25,
                'id_type' => 'drivers_license',
                'id_number' => 'DL123789',
                'address' => 'Latrikunda, Serrekunda',
                'phone' => '+2207888999',
                'nationality' => 'Gambian',
                'height' => 170,
                'weight' => 65,
                'eye_color' => 'brown',
                'hair_color' => 'black',
                'distinguishing_features' => 'None',
                'status' => 'wanted',
                'is_arrested' => false,
                'arrest_date' => null,
                'arrest_location' => null,
                'arresting_officer' => null,
                'notes' => 'Suspect identified by witnesses at the scene of assault at Westfield Junction.',
            ],
            [
                'first_name' => 'Ebrima',
                'last_name' => 'Bah',
                'alias' => 'Ebou',
                'gender' => 'male',
                'age' => 30,
                'id_type' => 'national_id',
                'id_number' => 'GN789012',
                'address' => 'Kololi, Kanifing Municipality',
                'phone' => '+2207222333',
                'nationality' => 'Gambian',
                'height' => 178,
                'weight' => 75,
                'eye_color' => 'brown',
                'hair_color' => 'black',
                'distinguishing_features' => 'Beard',
                'status' => 'person_of_interest',
                'is_arrested' => false,
                'arrest_date' => null,
                'arrest_location' => null,
                'arresting_officer' => null,
                'notes' => 'Person of interest in vehicle theft case. Seen near the hotel around the time of the incident.',
            ],
        ];
        
        foreach ($suspects as $index => $suspect) {
            $caseIndex = $index % count($cases->toArray());
            $officerIndex = $index % count($officers->toArray());
            
            CaseSuspect::create([
                'case_id' => $cases[$caseIndex]->id,
                'full_name' => $suspect['first_name'] . ' ' . $suspect['last_name'],
                'alias' => $suspect['alias'],
                'gender' => $suspect['gender'],
                'age' => $suspect['age'],
                'id_type' => $suspect['id_type'],
                'id_number' => $suspect['id_number'],
                'address' => $suspect['address'],
                'phone' => $suspect['phone'],
                'nationality' => $suspect['nationality'],
                'physical_description' => 'Height: ' . $suspect['height'] . 'cm, Weight: ' . $suspect['weight'] . 'kg, Eye color: ' . $suspect['eye_color'] . ', Hair color: ' . $suspect['hair_color'] . ', ' . $suspect['distinguishing_features'],
                'is_arrested' => $suspect['is_arrested'],
                'arrest_date' => $suspect['arrest_date'],
                'arrest_location' => $suspect['arrest_location'],
                'alleged_involvement' => $suspect['status'],
                'officer_notes' => $suspect['notes'],
            ]);
        }
    }
}
