<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\CaseVictim;
use App\Models\CaseRecord;
use App\Models\User;

class CaseVictimSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $cases = CaseRecord::all();
        $officers = User::where('is_officer', true)->get();
        
        // Individual victims
        $individualVictims = [
            [
                'first_name' => 'Alieu',
                'last_name' => 'Jallow',
                'gender' => 'male',
                'age' => 35,
                'id_type' => 'national_id',
                'id_number' => 'GN123456',
                'address' => 'Pipeline, Serrekunda',
                'phone' => '+2207654321',
                'email' => 'alieu.jallow@example.com',
                'occupation' => 'Shopkeeper',
                'nationality' => 'Gambian',
                'injury_status' => 'minor',
                'incident_date' => '2025-06-06',
                'incident_location' => 'Kairaba Avenue, Serrekunda',
                'incident_description' => 'Victim was threatened with a firearm during the robbery of his shop.',
            ],
            [
                'first_name' => 'Omar',
                'last_name' => 'Sowe',
                'gender' => 'male',
                'age' => 42,
                'id_type' => 'drivers_license',
                'id_number' => 'DL789012',
                'address' => 'Kololi, Kanifing Municipality',
                'phone' => '+2207123456',
                'email' => 'omar.sowe@example.com',
                'occupation' => 'Business Owner',
                'nationality' => 'Gambian',
                'injury_status' => 'none',
                'incident_date' => '2025-06-09',
                'incident_location' => 'Senegambia Beach Hotel, Kololi',
                'incident_description' => 'Vehicle stolen from hotel parking lot while victim was at a meeting.',
            ],
            [
                'first_name' => 'Isatou',
                'last_name' => 'Ceesay',
                'gender' => 'female',
                'age' => 28,
                'id_type' => 'national_id',
                'id_number' => 'GN456789',
                'address' => 'Westfield Junction, Serrekunda',
                'phone' => '+2207888999',
                'email' => 'isatou.ceesay@example.com',
                'occupation' => 'Teacher',
                'nationality' => 'Gambian',
                'injury_status' => 'severe',
                'incident_date' => '2025-06-10',
                'incident_location' => 'Westfield Junction, Serrekunda',
                'incident_description' => 'Victim was assaulted while waiting for transport. Sustained head injuries requiring hospitalization.',
            ],
        ];
        
        // Organization victims
        $organizationVictims = [
            [
                'name' => 'Fajara Electronics Store',
                'type' => 'business',
                'registration_number' => 'BRN12345',
                'address' => 'Fajara, Bakau',
                'phone' => '+2207111222',
                'email' => 'info@fajaraelectronics.com',
                'contact_person' => 'James Johnson',
                'contact_phone' => '+2207111222',
                'contact_email' => 'james@fajaraelectronics.com',
                'injury_status' => 'none',
                'incident_date' => '2025-06-04',
                'incident_location' => 'Fajara, Bakau',
                'incident_description' => 'Store was broken into overnight. Multiple electronic items stolen including laptops and mobile phones.',
            ],
            [
                'name' => 'Serrekunda Market Association',
                'type' => 'organization',
                'registration_number' => 'ORG78901',
                'address' => 'Serrekunda Market, Serrekunda',
                'phone' => '+2207333444',
                'email' => 'info@serrekundamarket.org',
                'contact_person' => 'Fatou Njie',
                'contact_phone' => '+2207555666',
                'contact_email' => 'fatou@serrekundamarket.org',
                'injury_status' => 'none',
                'incident_date' => '2025-06-11',
                'incident_location' => 'Serrekunda Market, Serrekunda',
                'incident_description' => 'Multiple market stalls vandalized overnight. Property damage and theft reported.',
            ],
        ];
        
        // Create individual victims
        foreach ($individualVictims as $index => $victim) {
            $caseIndex = $index % count($cases->toArray());
            $officerIndex = $index % count($officers->toArray());
            
            CaseVictim::create([
                'case_id' => $cases[$caseIndex]->id,
                'victim_type' => 'individual',
                'full_name' => $victim['first_name'] . ' ' . $victim['last_name'],
                'gender' => $victim['gender'],
                'age' => $victim['age'],
                'id_type' => $victim['id_type'],
                'id_number' => $victim['id_number'],
                'address' => $victim['address'],
                'phone' => $victim['phone'],
                'email' => $victim['email'],
                'occupation' => $victim['occupation'],
                'nationality' => $victim['nationality'],
                'injury_status' => $victim['injury_status'],
                'incident_date' => $victim['incident_date'],
                'incident_location' => $victim['incident_location'],
                'incident_description' => $victim['incident_description'],
                'requires_protection' => false,
                'protection_details' => null,
                'evidence_photos' => json_encode([]),
                'created_by_user_id' => $officers[$officerIndex]->id,
                'updated_by_user_id' => $officers[$officerIndex]->id,
            ]);
        }
        
        // Create organization victims
        foreach ($organizationVictims as $index => $victim) {
            $caseIndex = ($index + count($individualVictims)) % count($cases->toArray());
            $officerIndex = $index % count($officers->toArray());
            
            CaseVictim::create([
                'case_id' => $cases[$caseIndex]->id,
                'victim_type' => 'organization',
                'full_name' => $victim['contact_person'],
                'organization_name' => $victim['name'],
                'organization_type' => $victim['type'],
                'registration_number' => $victim['registration_number'],
                'address' => $victim['address'],
                'phone' => $victim['phone'],
                'email' => $victim['email'],
                'contact_person_name' => $victim['contact_person'],
                'contact_person_role' => 'Representative',
                'injury_status' => $victim['injury_status'],
                'incident_date' => $victim['incident_date'],
                'incident_location' => $victim['incident_location'],
                'incident_description' => $victim['incident_description'],
                'requires_protection' => false,
                'protection_details' => null,
                'evidence_photos' => json_encode([]),
                'created_by_user_id' => $officers[$officerIndex]->id,
                'updated_by_user_id' => $officers[$officerIndex]->id,
            ]);
        }
    }
}
