<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Run seeders in the correct order to maintain relationships
        $this->call([
            // Create settings first
            SettingsSeeder::class,    // Create application settings
            // Create users and stations first
            UserSeeder::class,          // Create users (admin and officers)
            StationSeeder::class,       // Create police stations
            
            // Create case-related data
            CaseRecordSeeder::class,    // Create case records (depends on users and stations)
            CaseVictimSeeder::class,    // Create victims (depends on cases and users)
            CaseSuspectSeeder::class,   // Create suspects (depends on cases and users)
            CaseStatementSeeder::class, // Create statements (depends on cases and users)
            CaseEvidenceSeeder::class,  // Create evidences (depends on cases and users)
            EvidenceTransferSeeder::class, // Create transfers (depends on evidences and users)
            EvidenceSeeder::class,     // Create standalone evidence records
            
            // Create bail-related data
            BailApplicationSeeder::class, // Create bail applications (depends on suspects and users)
            BailConditionSeeder::class,   // Create bail conditions (depends on bail applications)
            BailCheckinSeeder::class,     // Create bail check-ins (depends on bail conditions)
            
            // Note: PoliceStationSeeder and OfficerSeeder are not used as they're replaced by
            // StationSeeder and UserSeeder which provide similar functionality
            
            // Settings are created by SettingsSeeder
        ]);
    }
}
