<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\PoliceStation;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class OfficerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get stations by their codes
        $hq = PoliceStation::where('code', 'GPS-HQ')->first();
        $kanifing = PoliceStation::where('code', 'GPS-KAN')->first();
        $serrekunda = PoliceStation::where('code', 'GPS-SRK')->first();
        $brikama = PoliceStation::where('code', 'GPS-BRK')->first();
        
        // Check if stations were found
        if (!$hq || !$kanifing || !$serrekunda || !$brikama) {
            $this->command->error('Required police stations not found. Make sure to run the PoliceStationSeeder first.');
            return;
        }
        
        // Create admin user (not an officer) if doesn't exist
        if (!User::where('email', 'admin@gambiapolice.gov.gm')->exists()) {
            User::create([
            'name' => 'System Administrator',
            'email' => 'admin@gambiapolice.gov.gm',
            'password' => Hash::make('password'),
            'is_officer' => false,
        ]);
        }
        
        // Create officers for HQ
        $hqOfficers = [
            [
                'name' => 'James Gomez',
                'email' => 'jgomez@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Commissioner',
                'badge_number' => 'GPS-001',
                'station_id' => $hq->id,
            ],
            [
                'name' => 'Fatou Jallow',
                'email' => 'fjallow@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Deputy Commissioner',
                'badge_number' => 'GPS-002',
                'station_id' => $hq->id,
            ],
            [
                'name' => 'Omar Ceesay',
                'email' => 'oceesay@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Superintendent',
                'badge_number' => 'GPS-003',
                'station_id' => $hq->id,
            ],
        ];
        
        // Create officers for Kanifing
        $kanifingOfficers = [
            [
                'name' => 'Isatou Bah',
                'email' => 'ibah@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Chief Inspector',
                'badge_number' => 'GPS-101',
                'station_id' => $kanifing->id,
            ],
            [
                'name' => 'Lamin Sanneh',
                'email' => 'lsanneh@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Inspector',
                'badge_number' => 'GPS-102',
                'station_id' => $kanifing->id,
            ],
        ];
        
        // Create officers for Serrekunda
        $serrekundaOfficers = [
            [
                'name' => 'Mariama Jobe',
                'email' => 'mjobe@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Inspector',
                'badge_number' => 'GPS-201',
                'station_id' => $serrekunda->id,
            ],
            [
                'name' => 'Ebrima Touray',
                'email' => 'etouray@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Sergeant',
                'badge_number' => 'GPS-202',
                'station_id' => $serrekunda->id,
            ],
        ];
        
        // Create officers for Brikama
        $brikamaOfficers = [
            [
                'name' => 'Amie Njie',
                'email' => 'anjie@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Inspector',
                'badge_number' => 'GPS-301',
                'station_id' => $brikama->id,
            ],
            [
                'name' => 'Modou Jallow',
                'email' => 'mjallow@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Corporal',
                'badge_number' => 'GPS-302',
                'station_id' => $brikama->id,
            ],
        ];
        
        // Create unassigned officers
        $unassignedOfficers = [
            [
                'name' => 'Binta Fatty',
                'email' => 'bfatty@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Constable',
                'badge_number' => 'GPS-401',
                'station_id' => null,
            ],
            [
                'name' => 'Ousman Drammeh',
                'email' => 'odrammeh@gambiapolice.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'rank' => 'Constable',
                'badge_number' => 'GPS-402',
                'station_id' => null,
            ],
        ];
        
        // Create all officers
        foreach (array_merge($hqOfficers, $kanifingOfficers, $serrekundaOfficers, $brikamaOfficers, $unassignedOfficers) as $officer) {
            if (!User::where('email', $officer['email'])->exists()) {
                User::create($officer);
            }
        }
    }
}
