<?php

namespace Database\Seeders;

use App\Models\PoliceStation;
use Illuminate\Database\Seeder;

class PoliceStationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create headquarters if it doesn't exist
        if (!PoliceStation::where('code', 'GPS-HQ')->exists()) {
            PoliceStation::create([
            'name' => 'Gambia Police Headquarters',
            'code' => 'GPS-HQ',
            'address' => '1 Independence Drive',
            'city' => 'Banjul',
            'region' => 'Banjul',
            'phone' => '+220 4228888',
            'email' => 'hq@gambiapolice.gov.gm',
            'description' => 'Main headquarters of the Gambia Police Service',
            'is_headquarters' => true,
            'is_active' => true,
        ]);
        }

        // Create regional stations
        $stations = [
            [
                'name' => 'Kanifing Police Station',
                'code' => 'GPS-KAN',
                'address' => '123 Kairaba Avenue',
                'city' => 'Kanifing',
                'region' => 'Kanifing Municipal',
                'phone' => '+220 4466777',
                'email' => 'kanifing@gambiapolice.gov.gm',
                'description' => 'Kanifing Municipal regional police station',
                'is_headquarters' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Serrekunda Police Station',
                'code' => 'GPS-SRK',
                'address' => '45 Serrekunda Market Road',
                'city' => 'Serrekunda',
                'region' => 'Kanifing Municipal',
                'phone' => '+220 4455666',
                'email' => 'serrekunda@gambiapolice.gov.gm',
                'description' => 'Serrekunda area police station',
                'is_headquarters' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Brikama Police Station',
                'code' => 'GPS-BRK',
                'address' => '78 Brikama Highway',
                'city' => 'Brikama',
                'region' => 'West Coast',
                'phone' => '+220 4477888',
                'email' => 'brikama@gambiapolice.gov.gm',
                'description' => 'West Coast Region main police station',
                'is_headquarters' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Basse Police Station',
                'code' => 'GPS-BSE',
                'address' => '12 Basse Santa Su Road',
                'city' => 'Basse',
                'region' => 'Upper River',
                'phone' => '+220 5577888',
                'email' => 'basse@gambiapolice.gov.gm',
                'description' => 'Upper River Region main police station',
                'is_headquarters' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Farafenni Police Station',
                'code' => 'GPS-FRF',
                'address' => '34 Farafenni Central',
                'city' => 'Farafenni',
                'region' => 'North Bank',
                'phone' => '+220 5566777',
                'email' => 'farafenni@gambiapolice.gov.gm',
                'description' => 'North Bank Region police station',
                'is_headquarters' => false,
                'is_active' => true,
            ],
        ];

        foreach ($stations as $station) {
            if (!PoliceStation::where('code', $station['code'])->exists()) {
                PoliceStation::create($station);
            }
        }
    }
}
