<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // General Settings
        Setting::setValue('site_name', 'Police CCMS', 'general', 'string', 'Site name displayed in the header and title');
        Setting::setValue('site_description', 'Police Crime Case Management System', 'general', 'string', 'Brief description of the site');
        Setting::setValue('contact_email', 'admin@police-ccms.example.com', 'general', 'string', 'Primary contact email');
        Setting::setValue('timezone', 'UTC', 'general', 'string', 'Default timezone for the application');
        Setting::setValue('date_format', 'Y-m-d', 'general', 'string', 'Default date format');
        Setting::setValue('time_format', 'H:i', 'general', 'string', 'Default time format');
        
        // Logs Settings
        Setting::setValue('auto_cleanup_logs', '0', 'logs', 'boolean', 'Enable automatic log cleanup');
        Setting::setValue('log_cleanup_days', '30', 'logs', 'integer', 'Number of days to keep logs');
        
        // Backup Settings
        Setting::setValue('backup_frequency', 'daily', 'backup', 'string', 'How often to run automatic backups');
        Setting::setValue('backup_retention', '7', 'backup', 'integer', 'Number of days to keep backups');
        Setting::setValue('backup_time', '01:00', 'backup', 'string', 'Time to run backups (24-hour format)');
        
        // API Settings
        Setting::setValue('api_enabled', '1', 'api', 'boolean', 'Enable API access');
        Setting::setValue('api_throttle_rate', '60', 'api', 'integer', 'API rate limit per minute');
        Setting::setValue('api_token_expiry_days', '30', 'api', 'integer', 'Number of days before API tokens expire');
        
        // API Access Settings
        Setting::setValue('api_admin_access', '1', 'api_access', 'boolean', 'Allow administrators to access API');
        Setting::setValue('api_officer_access', '1', 'api_access', 'boolean', 'Allow police officers to access API');
        Setting::setValue('api_investigator_access', '1', 'api_access', 'boolean', 'Allow investigators to access API');
        Setting::setValue('api_clerk_access', '0', 'api_access', 'boolean', 'Allow clerks to access API');
    }
}
