<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PoliceStation;

class StationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $stations = [
            [
                'name' => 'Banjul Police Headquarters',
                'code' => 'GPS-HQ',
                'address' => 'Independence Drive, Banjul',
                'city' => 'Banjul',
                'region' => 'Greater Banjul Area',
                'phone' => '+2207200001',
                'email' => 'banjul.hq@police.gov.gm',
                'description' => 'Main headquarters of the Gambia Police Force',
                'is_headquarters' => true,
                'is_active' => true,
            ],
            [
                'name' => 'Serrekunda Police Station',
                'code' => 'GPS-SRK',
                'address' => 'Serrekunda Market Road, Serrekunda',
                'city' => 'Serrekunda',
                'region' => 'Kanifing Municipality',
                'phone' => '+2207200002',
                'email' => 'serrekunda@police.gov.gm',
                'description' => 'Police station serving the Serrekunda area',
                'is_headquarters' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Bakau Police Station',
                'code' => 'GPS-BAK',
                'address' => 'Atlantic Road, Bakau',
                'city' => 'Bakau',
                'region' => 'Kanifing Municipality',
                'phone' => '+2207200003',
                'email' => 'bakau@police.gov.gm',
                'description' => 'Police station serving the Bakau area',
                'is_headquarters' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Brikama Police Station',
                'code' => 'GPS-BRK',
                'address' => 'Main Road, Brikama',
                'city' => 'Brikama',
                'region' => 'West Coast Region',
                'phone' => '+2207200004',
                'email' => 'brikama@police.gov.gm',
                'description' => 'Police station serving the Brikama area',
                'is_headquarters' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Basse Police Station',
                'code' => 'GPS-BSS',
                'address' => 'Basse Santa Su, URR',
                'city' => 'Basse',
                'region' => 'Upper River Region',
                'phone' => '+2207200005',
                'email' => 'basse@police.gov.gm',
                'description' => 'Police station serving the Basse area',
                'is_headquarters' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Farafenni Police Station',
                'code' => 'GPS-FRF',
                'address' => 'Trans-Gambia Highway, Farafenni',
                'city' => 'Farafenni',
                'region' => 'North Bank Region',
                'phone' => '+2207200006',
                'email' => 'farafenni@police.gov.gm',
                'description' => 'Police station serving the Farafenni area',
                'is_headquarters' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Kanifing Police Station',
                'code' => 'GPS-KAN',
                'address' => 'Kanifing Estate, Kanifing',
                'city' => 'Kanifing',
                'region' => 'Kanifing Municipality',
                'phone' => '+2207200007',
                'email' => 'kanifing@police.gov.gm',
                'description' => 'Police station serving the Kanifing area',
                'is_headquarters' => false,
                'is_active' => true,
            ],
        ];
        
        foreach ($stations as $station) {
            if (!PoliceStation::where('code', $station['code'])->exists()) {
                PoliceStation::create($station);
            }
        }
    }
}
