<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create admin user (not an officer) if doesn't exist
        if (!User::where('email', 'admin@police.gov.gm')->exists()) {
            User::create([
                'name' => 'Admin User',
                'email' => 'admin@police.gov.gm',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
                'is_officer' => false,
                'badge_number' => null,
                'rank' => null,
            ]);
        }

        // Create police officers
        $officers = [
            [
                'name' => 'Lamin Bojang',
                'email' => 'lbojang@police.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'badge_number' => 'GPS-1001',
                'rank' => 'Inspector',
            ],
            [
                'name' => 'Fatou Ceesay',
                'email' => 'fceesay@police.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'badge_number' => 'GPS-1002',
                'rank' => 'Sergeant',
            ],
            [
                'name' => 'Modou Jallow',
                'email' => 'mjallow@police.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'badge_number' => 'GPS-1003',
                'rank' => 'Constable',
            ],
            [
                'name' => 'Fatou Jallow',
                'email' => 'fatou.jallow@police.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'badge_number' => 'GPF10004',
                'rank' => 'Inspector',
            ],
            [
                'name' => 'Modou Sowe',
                'email' => 'modou.sowe@police.gov.gm',
                'password' => Hash::make('password'),
                'is_officer' => true,
                'badge_number' => 'GPF10005',
                'rank' => 'Superintendent',
            ],
        ];
        
        foreach ($officers as $officer) {
            if (!User::where('email', $officer['email'])->exists()) {
                User::create([
                    'name' => $officer['name'],
                    'email' => $officer['email'],
                    'password' => Hash::make('password'),
                    'email_verified_at' => now(),
                    'is_officer' => true,
                    'badge_number' => $officer['badge_number'],
                    'rank' => $officer['rank'],
                ]);
            }
        }
    }
}
