# Gambia Police CCMS Mobile App

## Overview

The Gambia Police Crime Case Management System (GPCMS) Mobile App is a companion application to the existing web-based CCMS. This Flutter-based mobile application brings critical case management functionality to officers in the field, enabling real-time access to case information, evidence collection, and bail management on smartphones and tablets.

## Purpose

This mobile application extends the functionality of the Gambia Police CCMS web platform to field officers, allowing them to:

1. Access and update case information while away from the station
2. Collect evidence and statements directly at crime scenes
3. Process bail check-ins efficiently with mobile verification
4. View and manage their assigned cases and tasks
5. Receive real-time notifications about case updates and assignments

## Key Features

### Authentication & Security
- Secure biometric login (fingerprint/face recognition)
- Role-based access control matching web platform permissions
- Automatic timeout and secure data storage
- Offline authentication capabilities

### Officer Dashboard
- Personalized overview showing assigned cases and tasks
- Daily bail check-in schedule and notifications
- Case statistics and performance metrics
- Quick action buttons for common tasks

### Case Management
- View assigned and reported cases with complete details
- Case search with advanced filtering options
- Offline access to critical case information
- Case timeline visualization with updates and milestones
- Add case notes, updates, and status changes from the field

### Evidence Collection
- Capture photos and videos directly into case evidence
- Record audio statements with automatic transcription
- Scan documents using device camera
- Tag evidence with GPS location and timestamp
- Offline collection with background sync when connection is restored

### Bail Management
- Process bail check-ins with QR code scanning
- Verify suspect identity with photo comparison
- Record check-in details with GPS location verification
- View bail conditions and compliance history
- Generate alerts for missed check-ins

### Victim & Suspect Management
- Access victim and suspect profiles with photos and details
- Record new victim and witness statements in the field
- Update suspect status and location information
- Victim protection status monitoring
- Quick access to contact information for follow-ups

### Field Reporting
- Create incident reports from templates
- Submit field interview reports
- Generate preliminary investigation reports
- Attach media files to reports
- Save drafts for later completion

### Communication
- Secure messaging between officers on the same case
- Broadcast alerts from station commanders
- Notification system for case updates and assignments
- Emergency backup request functionality

### Maps & Location
- GPS tracking for patrol officers
- Mapping of crime scenes and incidents
- Nearest station locator
- Route planning to incident locations
- Geofencing for bail condition monitoring

## User Roles & Access

### Regular Officers
- View assigned cases
- Collect evidence and statements
- Process bail check-ins
- Submit field reports
- Access limited suspect database

### Lead Investigators
- All regular officer features
- Case assignment capabilities
- Investigation management tools
- Advanced analytics on case progress
- Team communication coordination

### Station Commanders
- All lead investigator features
- Station-wide performance metrics
- Resource allocation tools
- Approval workflows for sensitive actions
- Comprehensive reporting dashboard

## Technical Specifications

### Platform Requirements
- **Mobile OS**: Android 8.0+ and iOS 13.0+
- **Recommended Device**: Minimum 3GB RAM, 32GB storage
- **Connectivity**: Works offline with sync capabilities
- **Camera**: Required for evidence collection and document scanning
- **GPS**: Required for location tracking and verification
- **Biometrics**: Recommended for secure authentication

### Backend Integration
- REST API integration with existing Laravel backend
- JWT authentication for secure API access
- Efficient data synchronization protocols
- File compression for media uploads
- Encrypted local storage for sensitive data

### Data Privacy & Security
- End-to-end encryption for all communications
- Secure local storage with encryption
- Automatic data purging based on retention policies
- Audit logging of all user actions
- Remote wipe capability for lost devices

## Implementation Roadmap

### Phase 1: Core Functionality ✅
- User authentication and profile management
- Case viewing and basic updates
- Simple evidence collection (photos only)
- Offline data access for assigned cases
- Network service refactoring (ApiService)

#### Phase 1 Completion Notes

**ApiService Refactoring (Completed June 14, 2025)**

Successfully refactored the network layer by replacing the Dio package with the standard http package:

- Implemented all HTTP methods (GET, POST, PUT, PATCH, DELETE) using http package
- Added comprehensive error handling with app-specific exceptions
- Maintained token management with automatic refresh for expired tokens
- Implemented file upload functionality with proper MIME type detection
- Added connectivity checks before making requests
- Enhanced security with proper header management
- Improved testability with dependency injection

This refactoring provides a more lightweight and maintainable network implementation while preserving all the original functionality. The new implementation reduces external dependencies and provides a cleaner, more consistent API for the application's network requests.

### Phase 2: Field Operations
- Enhanced evidence collection (video, audio, documents)
- Bail check-in processing with QR codes
- GPS integration for location tracking
- Basic reporting capabilities

### Phase 3: Advanced Features
- Biometric verification for suspects
- Voice-to-text transcription
- Advanced analytics dashboard
- Cross-officer collaboration tools
- Push notifications

### Phase 4: Integration Expansion
- Court system integration
- External agency data sharing
- Public portal for victims to track cases
- Advanced predictive analytics
- Custom reporting tools

## Benefits

### For Officers
- Reduced paperwork and administrative burden
- More time for actual police work
- Better information access in the field
- Improved evidence collection capabilities
- Streamlined workflows for common tasks

### For Command Staff
- Better resource allocation through real-time data
- Improved officer accountability and tracking
- Enhanced data for strategic decision making
- More efficient case management
- Reduced administrative overhead

### For the Public
- Faster response to incidents and reports
- More accurate information collection
- Better case outcomes through improved evidence handling
- Enhanced transparency in police operations
- Improved victim services and communication

## Getting Started

### For Developers
1. Clone the repository
2. Install Flutter SDK (version 3.0+)
3. Configure API endpoints in the .env file
4. Run `flutter pub get` to install dependencies
5. Use `flutter run` to start the development server

### For Users
1. Download the app from the authorized distribution channel
2. Login with credentials provided by your station commander
3. Complete initial profile setup and preferences
4. Grant necessary permissions (camera, location, storage)
5. Complete the guided tutorial for basic functionality

---

## About the Gambia Police CCMS

The Gambia Police Crime Case Management System is a comprehensive digital solution for managing all aspects of police operations, including case management, evidence handling, suspect tracking, and reporting. The system streamlines police administrative work, improves data accuracy, and enhances collaboration between officers and departments.
