@extends('adminlte::page')

@section('title', 'Record Bail Check-in')

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1 class="m-0">Record Bail Check-in</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('bail-checkins.index') }}">Bail Check-ins</a></li>
                <li class="breadcrumb-item active">Record Check-in</li>
            </ol>
        </div>
    </div>
</div>
@stop

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">Check-in Details</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>

                <form action="{{ route('bail-checkins.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <h5><i class="icon fas fa-ban"></i> Error!</h5>
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="suspect_id">Suspect <span class="text-danger">*</span></label>
                                    <select name="suspect_id" id="suspect_id" class="form-control select2 @error('suspect_id') is-invalid @enderror" required>
                                        <option value="">Select Suspect</option>
                                        @foreach($suspects as $suspect)
                                            <option value="{{ $suspect->id }}" {{ old('suspect_id', $selectedSuspect ? $selectedSuspect->id : '') == $suspect->id ? 'selected' : '' }}>
                                                {{ $suspect->full_name_with_alias }} ({{ $suspect->identification_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('suspect_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bail_application_id">Bail Application <span class="text-danger">*</span></label>
                                    <select name="bail_application_id" id="bail_application_id" class="form-control select2 @error('bail_application_id') is-invalid @enderror" required>
                                        <option value="">Select Bail Application</option>
                                        @if($selectedBailApplication)
                                            <option value="{{ $selectedBailApplication->id }}" selected>
                                                #{{ $selectedBailApplication->id }} - {{ $selectedBailApplication->created_at->format('d/m/Y') }}
                                            </option>
                                        @endif
                                    </select>
                                    @error('bail_application_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="police_station_id">Police Station <span class="text-danger">*</span></label>
                                    <select name="police_station_id" id="police_station_id" class="form-control select2 @error('police_station_id') is-invalid @enderror" required>
                                        <option value="">Select Police Station</option>
                                        @foreach($policeStations as $station)
                                            <option value="{{ $station->id }}" {{ old('police_station_id') == $station->id ? 'selected' : '' }}>
                                                {{ $station->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('police_station_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">Status <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="">Select Status</option>
                                        <option value="scheduled" {{ old('status') == 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                        <option value="present" {{ old('status') == 'present' ? 'selected' : '' }}>Present</option>
                                        <option value="missed" {{ old('status') == 'missed' ? 'selected' : '' }}>Missed</option>
                                        <option value="excused" {{ old('status') == 'excused' ? 'selected' : '' }}>Excused</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="scheduled_time">Scheduled Time</label>
                                    <div class="input-group date" id="scheduled_time_picker" data-target-input="nearest">
                                        <input type="datetime-local" name="scheduled_time" id="scheduled_time" class="form-control @error('scheduled_time') is-invalid @enderror" value="{{ old('scheduled_time') }}">
                                        <div class="input-group-append" data-target="#scheduled_time_picker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                    </div>
                                    @error('scheduled_time')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="checkin_time">Check-in Time <span class="text-danger">*</span></label>
                                    <div class="input-group date" id="checkin_time_picker" data-target-input="nearest">
                                        <input type="datetime-local" name="checkin_time" id="checkin_time" class="form-control @error('checkin_time') is-invalid @enderror" value="{{ old('checkin_time', now()->format('Y-m-d\TH:i')) }}" required>
                                        <div class="input-group-append" data-target="#checkin_time_picker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                    </div>
                                    @error('checkin_time')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="is_present" name="is_present" value="1" {{ old('is_present') ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_present">Suspect is Present</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="notes">Notes</label>
                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3" placeholder="Enter any additional notes about this check-in">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Save Check-in
                        </button>
                        <a href="{{ route('bail-checkins.index') }}" class="btn btn-default">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

@section('js')
<script>
$(function() {
    // Initialize select2 for dropdowns
    $('.select2').select2({
        placeholder: 'Select an option',
        allowClear: true
    });
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Auto-update status based on is_present checkbox
    $('#is_present').change(function() {
        if ($(this).is(':checked')) {
            $('#status').val('present');
        } else {
            if ($('#status').val() === 'present') {
                $('#status').val('missed');
            }
        }
    });
    
    // Auto-check is_present when status is "present"
    $('#status').change(function() {
        if ($(this).val() === 'present') {
            $('#is_present').prop('checked', true);
        } else {
            $('#is_present').prop('checked', false);
        }
    });
    
    // Load bail applications when suspect changes
    $('#suspect_id').change(function() {
        const suspectId = $(this).val();
        if (suspectId) {
            // Show loading indicator
            $('#bail_application_id').prop('disabled', true);
            
            $.ajax({
                url: "{{ route('bail.get-suspects') }}",
                type: 'GET',
                data: { suspect_id: suspectId },
                dataType: 'json',
                success: function(data) {
                    $('#bail_application_id').empty();
                    $('#bail_application_id').append('<option value="">Select Bail Application</option>');
                    
                    if (data.bail_applications && data.bail_applications.length > 0) {
                        $.each(data.bail_applications, function(key, value) {
                            const created = new Date(value.created_at);
                            const formattedDate = created.toLocaleDateString('en-GB', {
                                day: '2-digit',
                                month: 'short',
                                year: 'numeric'
                            });
                            
                            $('#bail_application_id').append(
                                '<option value="' + value.id + '">#' + value.id + ' - ' + formattedDate + '</option>'
                            );
                        });
                    }
                    
                    // Enable dropdown after loading
                    $('#bail_application_id').prop('disabled', false);
                },
                error: function() {
                    // Handle error
                    toastr.error('Failed to load bail applications');
                    $('#bail_application_id').prop('disabled', false);
                }
            });
        } else {
            $('#bail_application_id').empty();
            $('#bail_application_id').append('<option value="">Select Bail Application</option>');
        }
    });
});
</script>
@stop
