@extends('adminlte::page')

@section('title', 'Edit Bail Check-in')

@section('content_header')
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>
                    <i class="fas fa-edit text-primary"></i> Edit Bail Check-in
                </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('bail-checkins.index') }}">Bail Check-ins</a></li>
                    <li class="breadcrumb-item active">Edit Check-in</li>
                </ol>
            </div>
        </div>
    </div>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-calendar-check mr-1"></i> Check-in Details
                        </h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>

                    <form action="{{ route('bail-checkins.update', $checkin->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Suspect</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-user"></i></span>
                                            </div>
                                            <input type="text" class="form-control" value="{{ $checkin->suspect->full_name }} ({{ $checkin->suspect->identification_number }})" readonly>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Bail Application</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-file-alt"></i></span>
                                            </div>
                                            <input type="text" class="form-control" value="#{{ $checkin->bailApplication->id }} - {{ $checkin->bailApplication->created_at->format('d M Y') }}" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="police_station_id">Police Station <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-building"></i></span>
                                            </div>
                                            <select name="police_station_id" id="police_station_id" class="form-control select2 @error('police_station_id') is-invalid @enderror" required>
                                                <option value="">Select Police Station</option>
                                                @foreach($policeStations as $station)
                                                    <option value="{{ $station->id }}" {{ old('police_station_id', $checkin->police_station_id) == $station->id ? 'selected' : '' }}>
                                                        {{ $station->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('police_station_id')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="status">Status <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-tag"></i></span>
                                            </div>
                                            <select name="status" id="status" class="form-control select2 @error('status') is-invalid @enderror" required>
                                                <option value="">Select Status</option>
                                                <option value="scheduled" {{ old('status', $checkin->status) == 'scheduled' ? 'selected' : '' }}>
                                                    <i class="fas fa-calendar"></i> Scheduled
                                                </option>
                                                <option value="present" {{ old('status', $checkin->status) == 'present' ? 'selected' : '' }}>
                                                    <i class="fas fa-check-circle"></i> Present
                                                </option>
                                                <option value="missed" {{ old('status', $checkin->status) == 'missed' ? 'selected' : '' }}>
                                                    <i class="fas fa-times-circle"></i> Missed
                                                </option>
                                                <option value="excused" {{ old('status', $checkin->status) == 'excused' ? 'selected' : '' }}>
                                                    <i class="fas fa-exclamation-circle"></i> Excused
                                                </option>
                                            </select>
                                            @error('status')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="scheduled_time">Scheduled Time</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="far fa-calendar-alt"></i></span>
                                            </div>
                                            <input type="datetime-local" name="scheduled_time" id="scheduled_time" class="form-control @error('scheduled_time') is-invalid @enderror" 
                                                   value="{{ old('scheduled_time', $checkin->scheduled_time ? $checkin->scheduled_time->format('Y-m-d\TH:i') : '') }}">
                                            @error('scheduled_time')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="checkin_time">Check-in Time <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="far fa-clock"></i></span>
                                            </div>
                                            <input type="datetime-local" name="checkin_time" id="checkin_time" class="form-control @error('checkin_time') is-invalid @enderror" 
                                                   value="{{ old('checkin_time', $checkin->checkin_time ? $checkin->checkin_time->format('Y-m-d\TH:i') : now()->format('Y-m-d\TH:i')) }}" required>
                                            @error('checkin_time')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" id="is_present" name="is_present" 
                                                   {{ old('is_present', $checkin->is_present) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="is_present">
                                                <strong>Suspect is Present</strong>
                                                <i class="fas fa-info-circle text-info ml-1" data-toggle="tooltip" title="Check this box if the suspect appeared for their check-in"></i>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="notes">Notes</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-sticky-note"></i></span>
                                    </div>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3" placeholder="Enter any additional notes about this check-in">{{ old('notes', $checkin->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-1"></i> Update Check-in
                            </button>
                            <a href="{{ route('bail-checkins.index') }}" class="btn btn-default">
                                <i class="fas fa-times-circle mr-1"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>
$(function() {
    // Initialize select2 for dropdowns
    $('.select2').select2({
        placeholder: 'Select an option',
        allowClear: true
    });
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Auto-update status based on is_present checkbox
    $('#is_present').change(function() {
        if ($(this).is(':checked')) {
            $('#status').val('present');
        } else {
            if ($('#status').val() === 'present') {
                $('#status').val('missed');
            }
        }
    });
    
    // Auto-check is_present when status is "present"
    $('#status').change(function() {
        if ($(this).val() === 'present') {
            $('#is_present').prop('checked', true);
        } else {
            $('#is_present').prop('checked', false);
        }
    });
});
</script>
@stop
