@extends('adminlte::page')

@section('title', 'Bail Check-ins')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Bail Check-ins</h1>
        <a href="{{ route('bail-checkins.create') }}" class="btn btn-primary"><i class="fas fa-plus"></i> New Check-in</a>
    </div>
@stop

@section('content')
<div class="row">
    <div class="col-md-12">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                {{ session('success') }}
            </div>
        @endif

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Filter Bail Check-ins</h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('bail-checkins.index') }}" method="GET">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Police Station</label>
                                <select name="police_station_id" class="form-control select2">
                                    <option value="">All Stations</option>
                                    @foreach($policeStations as $station)
                                        <option value="{{ $station->id }}" {{ request('police_station_id') == $station->id ? 'selected' : '' }}>
                                            {{ $station->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Suspect</label>
                                <select name="suspect_id" class="form-control select2">
                                    <option value="">All Suspects</option>
                                    @foreach($suspects as $suspect)
                                        <option value="{{ $suspect->id }}" {{ request('suspect_id') == $suspect->id ? 'selected' : '' }}>
                                            {{ $suspect->full_name_with_alias }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Status</label>
                                <select name="status" class="form-control">
                                    <option value="">All Statuses</option>
                                    <option value="scheduled" {{ request('status') == 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                    <option value="present" {{ request('status') == 'present' ? 'selected' : '' }}>Present</option>
                                    <option value="missed" {{ request('status') == 'missed' ? 'selected' : '' }}>Missed</option>
                                    <option value="excused" {{ request('status') == 'excused' ? 'selected' : '' }}>Excused</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Date From</label>
                                <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Date To</label>
                                <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                            </div>
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                                <a href="{{ route('bail-checkins.index') }}" class="btn btn-default">
                                    <i class="fas fa-sync"></i> Reset
                                </a>
                            </div>
                        </div>
                    </div>
                </form>

            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Bail Check-ins List</h3>
                <div class="card-tools">
                    <a href="{{ route('bail-checkins.today') }}" class="btn btn-sm btn-info">
                        <i class="fas fa-calendar-day"></i> Today's Check-ins
                    </a>
                    <a href="{{ route('bail-checkins.stats') }}" class="btn btn-sm btn-success ml-1">
                        <i class="fas fa-chart-bar"></i> Statistics
                    </a>
                </div>
            </div>
            <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Suspect</th>
                            <th>Police Station</th>
                            <th>Scheduled Time</th>
                            <th>Check-in Time</th>
                            <th>Status</th>
                            <th>Recorded By</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($checkins as $checkin)
                            <tr>
                                <td>{{ $checkin->id }}</td>
                                <td>
                                    <a href="{{ route('case-suspects.show', $checkin->suspect_id) }}">
                                        {{ $checkin->suspect->full_name_with_alias }}
                                    </a>
                                </td>
                                <td>{{ $checkin->policeStation->name }}</td>
                                <td>{{ $checkin->scheduled_time ? $checkin->scheduled_time->format('d/m/Y h:i A') : 'N/A' }}</td>
                                <td>{{ $checkin->checkin_time ? $checkin->checkin_time->format('d/m/Y h:i A') : 'N/A' }}</td>
                                <td>{!! $checkin->status_badge !!}</td>
                                <td>{{ $checkin->recordedBy ? $checkin->recordedBy->name : 'N/A' }}</td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('bail-checkins.show', $checkin->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('bail-checkins.edit', $checkin->id) }}" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#delete-modal-{{ $checkin->id }}">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                    
                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="delete-modal-{{ $checkin->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $checkin->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteModalLabel{{ $checkin->id }}">Confirm Delete</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Are you sure you want to delete this check-in record? This action cannot be undone.
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                    <form action="{{ route('bail-checkins.destroy', $checkin->id) }}" method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger">Delete</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center">No check-in records found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="card-footer clearfix">
                {{ $checkins->appends(request()->query())->links() }}
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Initialize select2
            $('.select2').select2();
            
            // Enable tooltips
            $('[data-toggle="tooltip"]').tooltip();
            
            // Initialize select2 for suspect dropdown if available
            if ($.fn.select2) {
                $('#suspect_id').select2({
                    placeholder: 'Select a suspect',
                    allowClear: true
                });
            }
        });
    </script>
@stop
