@extends('adminlte::page')

@section('title', 'View Bail Check-in')

@section('content_header')
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>
                    <i class="fas fa-calendar-check text-primary"></i> Bail Check-in Details
                </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('bail-checkins.index') }}">Bail Check-ins</a></li>
                    <li class="breadcrumb-item active">View Check-in</li>
                </ol>
            </div>
        </div>
    </div>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Check-in #{{ $checkin->id }}</h3>
                        <div class="card-tools">
                            <a href="{{ route('bail-checkins.edit', $checkin->id) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal">
                                <i class="fas fa-trash"></i> Delete
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header bg-light">
                                        <h3 class="card-title">Suspect Information</h3>
                                    </div>
                                    <div class="card-body">
                                        <table class="table table-bordered">
                                            <tr>
                                                <th style="width: 30%">Full Name</th>
                                                <td>
                                                    <a href="{{ route('case-suspects.show', $checkin->suspect_id) }}">
                                                        {{ $checkin->suspect->full_name }}
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>ID Number</th>
                                                <td>{{ $checkin->suspect->identification_number }}</td>
                                            </tr>
                                            <tr>
                                                <th>Bail Application</th>
                                                <td>
                                                    <a href="{{ route('bail.show', $checkin->bail_application_id) }}">
                                                        #{{ $checkin->bailApplication->id }} ({{ $checkin->bailApplication->created_at->format('d M Y') }})
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Case Reference</th>
                                                <td>
                                                    @if($checkin->bailApplication->case)
                                                        <a href="{{ route('cases.show', $checkin->bailApplication->case_id) }}">
                                                            {{ $checkin->bailApplication->case->case_number }}
                                                        </a>
                                                    @else
                                                        N/A
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header bg-light">
                                        <h3 class="card-title">Check-in Details</h3>
                                    </div>
                                    <div class="card-body">
                                        <table class="table table-bordered">
                                            <tr>
                                                <th style="width: 30%">Status</th>
                                                <td>
                                                    @if($checkin->status == 'present')
                                                        <span class="badge badge-success"><i class="fas fa-check-circle mr-1"></i> Present</span>
                                                    @elseif($checkin->status == 'missed')
                                                        <span class="badge badge-danger"><i class="fas fa-times-circle mr-1"></i> Missed</span>
                                                    @elseif($checkin->status == 'excused')
                                                        <span class="badge badge-warning"><i class="fas fa-exclamation-circle mr-1"></i> Excused</span>
                                                    @else
                                                        <span class="badge badge-secondary"><i class="fas fa-question-circle mr-1"></i> {{ ucfirst($checkin->status) }}</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Presence</th>
                                                <td>
                                                    @if($checkin->is_present)
                                                        <span class="badge badge-success">Present</span>
                                                    @else
                                                        <span class="badge badge-danger">Absent</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Police Station</th>
                                                <td>{{ $checkin->policeStation->name }}</td>
                                            </tr>
                                            <tr>
                                                <th>Scheduled Time</th>
                                                <td>{{ $checkin->scheduled_time ? $checkin->scheduled_time->format('d M Y, h:i A') : 'N/A' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Check-in Time</th>
                                                <td>{{ $checkin->checkin_time ? $checkin->checkin_time->format('d M Y, h:i A') : 'N/A' }}</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header bg-light">
                                        <h3 class="card-title">Additional Information</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label>Notes</label>
                                            <div class="p-2 bg-light rounded">
                                                {!! $checkin->notes ? nl2br(e($checkin->notes)) : '<em>No notes provided</em>' !!}
                                            </div>
                                        </div>
                                        
                                        <table class="table table-bordered mt-3">
                                            <tr>
                                                <th style="width: 30%">Recorded By</th>
                                                <td>{{ $checkin->recordedBy ? $checkin->recordedBy->name : 'N/A' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Created By</th>
                                                <td>{{ $checkin->createdByUser ? $checkin->createdByUser->name : 'N/A' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Created At</th>
                                                <td>{{ $checkin->created_at->format('d M Y, h:i A') }}</td>
                                            </tr>
                                            <tr>
                                                <th>Last Updated By</th>
                                                <td>{{ $checkin->updatedByUser ? $checkin->updatedByUser->name : 'N/A' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Last Updated At</th>
                                                <td>{{ $checkin->updated_at->format('d M Y, h:i A') }}</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <a href="{{ route('bail-checkins.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this check-in record?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <form action="{{ route('bail-checkins.destroy', $checkin->id) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@stop
