@extends('adminlte::page')

@section('title', 'Bail Check-in Statistics')

@section('content_header')
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1><i class="fas fa-chart-bar mr-2"></i>Bail Check-in Statistics</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="fas fa-home"></i> Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('bail-checkins.index') }}">Bail Check-ins</a></li>
                    <li class="breadcrumb-item active">Statistics</li>
                </ol>
            </div>
        </div>
    </div>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12 mb-3">
                <div class="card card-outline card-primary">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-filter mr-2"></i>Filter Statistics</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('bail-checkins.stats') }}" method="GET">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="date_from">Date From</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                            </div>
                                            <input type="date" name="date_from" id="date_from" class="form-control" value="{{ $startDate->format('Y-m-d') }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="date_to">Date To</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                            </div>
                                            <input type="date" name="date_to" id="date_to" class="form-control" value="{{ $endDate->format('Y-m-d') }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="police_station_id">Police Station</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-building"></i></span>
                                            </div>
                                            <select name="police_station_id" id="police_station_id" class="form-control select2">
                                                <option value="">All Stations</option>
                                                @foreach($policeStations as $station)
                                                    <option value="{{ $station->id }}" {{ request('police_station_id') == $station->id ? 'selected' : '' }}>
                                                        {{ $station->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search mr-1"></i> Apply Filter
                                    </button>
                                    <a href="{{ route('bail-checkins.stats') }}" class="btn btn-default ml-2">
                                        <i class="fas fa-undo mr-1"></i> Reset
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-3">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>{{ $totalScheduled }}</h3>
                        <p>Scheduled</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-calendar"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>{{ $totalPresent }}</h3>
                        <p>Present</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-check"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h3>{{ $totalMissed }}</h3>
                        <p>Missed</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-times"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>{{ $totalExcused }}</h3>
                        <p>Excused</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-exclamation"></i>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-8">
                <div class="card card-outline card-info">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-chart-line mr-2"></i>Daily Check-in Trends</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="checkinsChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card card-outline card-success">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-tachometer-alt mr-2"></i>Compliance Rate</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body text-center">
                        <div id="complianceGauge" style="height: 200px;"></div>
                        <h3 class="mt-3">{{ $complianceRate }}%</h3>
                        <p class="text-muted">Overall compliance rate for the selected period</p>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6">
                <div class="card card-outline card-danger">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-user-times mr-2"></i>Top 5 Suspects with Missed Check-ins</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Suspect</th>
                                    <th>Missed Count</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($suspectsMostMissed as $item)
                                    <tr>
                                        <td>
                                            <a href="{{ route('case-suspects.show', $item->suspect_id) }}">
                                                {{ $item->suspect->full_name }}
                                            </a>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">{{ $item->missed_count }}</span>
                                        </td>
                                        <td>
                                            <a href="{{ route('case-suspects.show', $item->suspect_id) }}" class="btn btn-sm btn-info" data-toggle="tooltip" title="View Suspect Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="text-center">No missed check-ins recorded.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card card-outline card-primary">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-building mr-2"></i>Station Compliance Rates</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Police Station</th>
                                    <th>Total Check-ins</th>
                                    <th>Present</th>
                                    <th>Missed</th>
                                    <th>Compliance Rate</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($stationStats as $stat)
                                    <tr>
                                        <td>{{ $stat->policeStation->name }}</td>
                                        <td>{{ $stat->total_count }}</td>
                                        <td>{{ $stat->present_count }}</td>
                                        <td>{{ $stat->missed_count }}</td>
                                        <td>
                                            <div class="progress">
                                                <div class="progress-bar bg-success" role="progressbar" 
                                                     style="width: {{ $stat->compliance_rate }}%" 
                                                     aria-valuenow="{{ $stat->compliance_rate }}" 
                                                     aria-valuemin="0" 
                                                     aria-valuemax="100">{{ $stat->compliance_rate }}%</div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center">No station statistics available.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/gauge-chart@0.5.3/dist/bundle.min.js"></script>

<script>
    $(function() {
        // Initialize select2 for dropdowns if available
        if ($.fn.select2) {
            $('.select2').select2({
                placeholder: 'Select a police station',
                allowClear: true,
                theme: 'bootstrap4'
            });
        }
        
        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
        
        // Daily check-ins chart
        const ctx = document.getElementById('checkinsChart').getContext('2d');
        const dailyStats = @json($dailyStats);
        
        const labels = dailyStats.map(item => item.date);
        const presentData = dailyStats.map(item => item.present_count);
        const missedData = dailyStats.map(item => item.missed_count);
        const excusedData = dailyStats.map(item => item.excused_count);
        const scheduledData = dailyStats.map(item => item.scheduled_count);
        
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: labels,
                datasets: [
                    {
                        label: 'Present',
                        data: presentData,
                        borderColor: '#28a745',
                        backgroundColor: 'rgba(40, 167, 69, 0.2)',
                        tension: 0.1,
                        fill: true
                    },
                    {
                        label: 'Missed',
                        data: missedData,
                        borderColor: '#dc3545',
                        backgroundColor: 'rgba(220, 53, 69, 0.2)',
                        tension: 0.1,
                        fill: true
                    },
                    {
                        label: 'Excused',
                        data: excusedData,
                        borderColor: '#ffc107',
                        backgroundColor: 'rgba(255, 193, 7, 0.2)',
                        tension: 0.1,
                        fill: true
                    },
                    {
                        label: 'Scheduled',
                        data: scheduledData,
                        borderColor: '#17a2b8',
                        backgroundColor: 'rgba(23, 162, 184, 0.2)',
                        tension: 0.1,
                        fill: true
                    }
                ]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });
        
        // Compliance gauge
        const complianceRate = {{ $complianceRate }};
        const gaugeElement = document.getElementById('complianceGauge');
        
        GaugeChart.gaugeChart(gaugeElement, {
            hasNeedle: true,
            needleColor: '#464A4F',
            needleUpdateSpeed: 1000,
            arcColors: ['#dc3545', '#ffc107', '#28a745'],
            arcDelimiters: [30, 70],
            rangeLabel: ['0%', '100%'],
            centralLabel: complianceRate + '%',
        }).updateNeedle(complianceRate);
    });
</script>
@stop
