@extends('adminlte::page')

@section('title', 'Today\'s Bail Check-ins')

@section('content_header')
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1><i class="fas fa-calendar-check mr-2"></i>Today's Bail Check-ins</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="fas fa-home"></i> Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('bail-checkins.index') }}">Bail Check-ins</a></li>
                    <li class="breadcrumb-item active">Today's Check-ins</li>
                </ol>
            </div>
        </div>
    </div>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12 mb-3">
                <div class="card card-outline card-primary">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-filter mr-2"></i>Filter Check-ins</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('bail-checkins.today') }}" method="GET">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="police_station_id">Police Station</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-building"></i></span>
                                            </div>
                                            <select name="police_station_id" id="police_station_id" class="form-control select2">
                                                <option value="">All Stations</option>
                                                @foreach($policeStations as $station)
                                                    <option value="{{ $station->id }}" {{ $policeStationId == $station->id ? 'selected' : '' }}>
                                                        {{ $station->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div class="input-group">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-search mr-1"></i> Filter
                                            </button>
                                            <a href="{{ route('bail-checkins.today') }}" class="btn btn-default ml-2">
                                                <i class="fas fa-undo mr-1"></i> Reset
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-12">
                <div class="card card-outline card-primary">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-user-clock mr-2"></i>Suspects Due to Check-in Today</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <a href="{{ route('bail-checkins.create') }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> Record New Check-in
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Suspect</th>
                                        <th>ID Number</th>
                                        <th>Case Reference</th>
                                        <th>Reporting Schedule</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($suspectsDueToday as $suspect)
                                        @php
                                            $bailApplication = $suspect->bailApplications->first();
                                            $condition = App\Models\BailCondition::where('bail_application_id', $bailApplication->id)
                                                ->where('condition_type', 'reporting')
                                                ->where('requires_reporting', true)
                                                ->first();
                                            
                                            // Check if there's already a check-in recorded for today
                                            $todayCheckin = null;
                                            foreach($scheduled as $checkin) {
                                                if ($checkin->suspect_id == $suspect->id) {
                                                    $todayCheckin = $checkin;
                                                    break;
                                                }
                                            }
                                            
                                            foreach($present as $checkin) {
                                                if ($checkin->suspect_id == $suspect->id) {
                                                    $todayCheckin = $checkin;
                                                    break;
                                                }
                                            }
                                            
                                            foreach($missed as $checkin) {
                                                if ($checkin->suspect_id == $suspect->id) {
                                                    $todayCheckin = $checkin;
                                                    break;
                                                }
                                            }
                                            
                                            foreach($excused as $checkin) {
                                                if ($checkin->suspect_id == $suspect->id) {
                                                    $todayCheckin = $checkin;
                                                    break;
                                                }
                                            }
                                        @endphp
                                        <tr>
                                            <td>
                                                <a href="{{ route('case-suspects.show', $suspect->id) }}">
                                                    {{ $suspect->full_name }}
                                                </a>
                                            </td>
                                            <td>{{ $suspect->identification_number }}</td>
                                            <td>
                                                @if($bailApplication->case)
                                                    <a href="{{ route('cases.show', $bailApplication->case_id) }}">
                                                        {{ $bailApplication->case->case_number }}
                                                    </a>
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                            <td>
                                                @if($condition)
                                                    {{ $condition->reporting_schedule_text }}
                                                    <br>
                                                    <small class="text-muted">
                                                        Time window: {{ $condition->reporting_time_start }} - {{ $condition->reporting_time_end }}
                                                    </small>
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                            <td>
                                                @if($todayCheckin)
                                                    @if($todayCheckin->status == 'present')
                                                        <span class="badge badge-success"><i class="fas fa-check-circle mr-1"></i> Present</span>
                                                    @elseif($todayCheckin->status == 'missed')
                                                        <span class="badge badge-danger"><i class="fas fa-times-circle mr-1"></i> Missed</span>
                                                    @elseif($todayCheckin->status == 'excused')
                                                        <span class="badge badge-warning"><i class="fas fa-exclamation-circle mr-1"></i> Excused</span>
                                                    @else
                                                        <span class="badge badge-info"><i class="fas fa-calendar mr-1"></i> Scheduled</span>
                                                    @endif
                                                @else
                                                    <span class="badge badge-secondary"><i class="fas fa-clock mr-1"></i> Pending</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($todayCheckin)
                                                    <a href="{{ route('bail-checkins.edit', $todayCheckin->id) }}" class="btn btn-sm btn-primary">
                                                        <i class="fas fa-edit"></i> Update
                                                    </a>
                                                    <a href="{{ route('bail-checkins.show', $todayCheckin->id) }}" class="btn btn-sm btn-info" data-toggle="tooltip" title="View Check-in Details">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                @else
                                                    <a href="{{ route('bail-checkins.create', ['suspect_id' => $suspect->id]) }}" class="btn btn-sm btn-success">
                                                        <i class="fas fa-check"></i> Record Check-in
                                                    </a>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center">No suspects due to check in today.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-3">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>{{ $scheduled->count() }}</h3>
                        <p>Scheduled</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-calendar"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>{{ $present->count() }}</h3>
                        <p>Present</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-check"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h3>{{ $missed->count() }}</h3>
                        <p>Missed</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-times"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>{{ $excused->count() }}</h3>
                        <p>Excused</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-exclamation"></i>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6">
                <div class="card card-outline card-success">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-check-circle mr-2"></i>Present</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Suspect</th>
                                        <th>Check-in Time</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($present as $checkin)
                                        <tr>
                                            <td>{{ $checkin->suspect->full_name }}</td>
                                            <td>{{ $checkin->checkin_time->format('h:i A') }}</td>
                                            <td>
                                                <a href="{{ route('bail-checkins.show', $checkin->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="3" class="text-center">No present check-ins today.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card card-outline card-danger">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-times-circle mr-2"></i>Missed</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Suspect</th>
                                        <th>Scheduled Time</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($missed as $checkin)
                                        <tr>
                                            <td>{{ $checkin->suspect->full_name }}</td>
                                            <td>{{ $checkin->scheduled_time ? $checkin->scheduled_time->format('h:i A') : 'N/A' }}</td>
                                            <td>
                                                <a href="{{ route('bail-checkins.edit', $checkin->id) }}" class="btn btn-sm btn-primary" data-toggle="tooltip" title="Edit Check-in">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="{{ route('bail-checkins.show', $checkin->id) }}" class="btn btn-sm btn-info" data-toggle="tooltip" title="View Check-in Details">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="3" class="text-center">No missed check-ins today.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>
    $(function() {
        // Initialize select2 for dropdowns if available
        if ($.fn.select2) {
            $('.select2').select2({
                placeholder: 'Select a police station',
                allowClear: true,
                theme: 'bootstrap4'
            });
        }
        
        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>
@stop
