@extends('adminlte::page')

@section('title', 'Create Bail Application')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Create Bail Application</h1>
        <a href="{{ route('bail.index') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back to List</a>
    </div>
@stop

@section('content')

<div class="row">
    <div class="col-md-12">
        @if($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('bail.store') }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Application Details</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="application_number">Application Number <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="application_number" name="application_number" value="{{ old('application_number', $applicationNumber) }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="application_date">Application Date <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control" id="application_date" name="application_date" value="{{ old('application_date', now()->format('Y-m-d')) }}" required>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="case_id">Case <span class="text-danger">*</span></label>
                                        <select class="form-control select2" id="case_id" name="case_id" required>
                                            <option value="">Select Case</option>
                                            @foreach($cases as $case)
                                                <option value="{{ $case->id }}" {{ old('case_id', request('case_id')) == $case->id ? 'selected' : '' }}>
                                                    {{ $case->case_number }} - {{ $case->title }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="suspect_id">Suspect <span class="text-danger">*</span></label>
                                        <select class="form-control select2" id="suspect_id" name="suspect_id" required>
                                            <option value="">Select Suspect</option>
                                            @foreach($suspects as $suspect)
                                                <option value="{{ $suspect->id }}" {{ old('suspect_id') == $suspect->id ? 'selected' : '' }}>
                                                    {{ $suspect->first_name }} {{ $suspect->last_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="status">Status <span class="text-danger">*</span></label>
                                        <select class="form-control" id="status" name="status" required>
                                            <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                            <option value="approved" {{ old('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                                            <option value="rejected" {{ old('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                                            <option value="revoked" {{ old('status') == 'revoked' ? 'selected' : '' }}>Revoked</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="amount">Bail Amount (GMD)</label>
                                        <input type="number" step="0.01" min="0" class="form-control" id="amount" name="amount" value="{{ old('amount') }}">
                                    </div>
                                </div>
                            </div>

                            <div class="row approval-fields" style="{{ old('status') == 'approved' ? '' : 'display: none;' }}">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="approval_date">Approval Date <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control" id="approval_date" name="approval_date" value="{{ old('approval_date', now()->format('Y-m-d')) }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="expiry_date">Expiry Date</label>
                                        <input type="date" class="form-control" id="expiry_date" name="expiry_date" value="{{ old('expiry_date') }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="approved_by">Approved By <span class="text-danger">*</span></label>
                                        <select class="form-control select2" id="approved_by" name="approved_by">
                                            <option value="">Select Officer</option>
                                            @foreach($officers as $officer)
                                                <option value="{{ $officer->id }}" {{ old('approved_by') == $officer->id ? 'selected' : '' }}>
                                                    {{ $officer->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="reason">Reason for Bail Application</label>
                                <textarea class="form-control" id="reason" name="reason" rows="3">{{ old('reason') }}</textarea>
                            </div>

                            <div class="form-group">
                                <label for="notes">Additional Notes</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Bail Conditions</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" id="add-condition">
                                    <i class="fas fa-plus"></i> Add Condition
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="conditions-container">
                                @if(old('condition_type'))
                                    @foreach(old('condition_type') as $key => $type)
                                        <div class="row condition-row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Condition Type</label>
                                                    <select class="form-control" name="condition_type[]">
                                                        <option value="">Select Type</option>
                                                        @foreach($conditionTypes as $value => $label)
                                                            <option value="{{ $value }}" {{ $type == $value ? 'selected' : '' }}>{{ $label }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <label>Description</label>
                                                    <textarea class="form-control" name="condition_description[]" rows="2">{{ old('condition_description')[$key] ?? '' }}</textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-1">
                                                <div class="form-group">
                                                    <label>&nbsp;</label>
                                                    <button type="button" class="btn btn-danger btn-block remove-condition">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="row condition-row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Condition Type</label>
                                                <select class="form-control" name="condition_type[]">
                                                    <option value="">Select Type</option>
                                                    @foreach($conditionTypes as $value => $label)
                                                        <option value="{{ $value }}">{{ $label }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-7">
                                            <div class="form-group">
                                                <label>Description</label>
                                                <textarea class="form-control" name="condition_description[]" rows="2"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="form-group">
                                                <label>&nbsp;</label>
                                                <button type="button" class="btn btn-danger btn-block remove-condition">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Surety Information</h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="surety_name">Full Name</label>
                                <input type="text" class="form-control" id="surety_name" name="surety_name" value="{{ old('surety_name') }}">
                            </div>
                            <div class="form-group">
                                <label for="surety_contact">Contact Number</label>
                                <input type="text" class="form-control" id="surety_contact" name="surety_contact" value="{{ old('surety_contact') }}">
                            </div>
                            <div class="form-group">
                                <label for="surety_address">Address</label>
                                <textarea class="form-control" id="surety_address" name="surety_address" rows="2">{{ old('surety_address') }}</textarea>
                            </div>
                            <div class="form-group">
                                <label for="surety_relationship">Relationship to Suspect</label>
                                <input type="text" class="form-control" id="surety_relationship" name="surety_relationship" value="{{ old('surety_relationship') }}">
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="surety_id_type">ID Type</label>
                                        <select class="form-control" id="surety_id_type" name="surety_id_type">
                                            <option value="">Select ID Type</option>
                                            <option value="national_id" {{ old('surety_id_type') == 'national_id' ? 'selected' : '' }}>National ID</option>
                                            <option value="passport" {{ old('surety_id_type') == 'passport' ? 'selected' : '' }}>Passport</option>
                                            <option value="drivers_license" {{ old('surety_id_type') == 'drivers_license' ? 'selected' : '' }}>Driver's License</option>
                                            <option value="voter_card" {{ old('surety_id_type') == 'voter_card' ? 'selected' : '' }}>Voter's Card</option>
                                            <option value="other" {{ old('surety_id_type') == 'other' ? 'selected' : '' }}>Other</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="surety_id_number">ID Number</label>
                                        <input type="text" class="form-control" id="surety_id_number" name="surety_id_number" value="{{ old('surety_id_number') }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="fas fa-save"></i> Save Bail Application
                            </button>
                            <a href="{{ route('bail.index') }}" class="btn btn-default btn-block">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
<script>
    $(document).ready(function() {
        // Initialize Select2
        $('.select2').select2();

        // Show/hide approval fields based on status
        $('#status').on('change', function() {
            if ($(this).val() === 'approved') {
                $('.approval-fields').show();
            } else {
                $('.approval-fields').hide();
            }
        });

        // Add new condition
        $('#add-condition').on('click', function() {
            const conditionRow = `
                <div class="row condition-row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Condition Type</label>
                            <select class="form-control" name="condition_type[]">
                                <option value="">Select Type</option>
                                @foreach($conditionTypes as $value => $label)
                                    <option value="{{ $value }}">{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <label>Description</label>
                            <textarea class="form-control" name="condition_description[]" rows="2"></textarea>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <button type="button" class="btn btn-danger btn-block remove-condition">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            `;
            $('#conditions-container').append(conditionRow);
        });

        // Remove condition
        $(document).on('click', '.remove-condition', function() {
            $(this).closest('.condition-row').remove();
        });

        // Load suspects when case changes
        $('#case_id').on('change', function() {
            const caseId = $(this).val();
            if (!caseId) {
                $('#suspect_id').empty().append('<option value="">Select Suspect</option>');
                return;
            }

            $.ajax({
                url: "{{ route('bail.get-suspects') }}",
                type: 'GET',
                data: { case_id: caseId },
                success: function(data) {
                    let options = '<option value="">Select Suspect</option>';
                    data.forEach(function(suspect) {
                        options += `<option value="${suspect.id}">${suspect.name}</option>`;
                    });
                    $('#suspect_id').html(options);
                }
            });
        });
        
        // Enable tooltips
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>
@stop
