@extends('adminlte::page')

@section('title', 'Edit Bail Application')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Edit Bail Application</h1>
        <div>
            <a href="{{ route('bail.index') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back to List</a>
            <a href="{{ route('bail.show', $application->id) }}" class="btn btn-info"><i class="fas fa-eye"></i> View Details</a>
        </div>
    </div>
@stop

@section('content')

<div class="row">
    <div class="col-md-12">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('bail.update', $application->id) }}" method="POST" id="bailForm">
            @csrf
            @method('PUT')
            
            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Application Details</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="application_number">Application Number</label>
                                        <input type="text" class="form-control" id="application_number" name="application_number" value="{{ $application->application_number }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="application_date">Application Date</label>
                                        <input type="date" class="form-control" id="application_date" name="application_date" value="{{ $application->application_date->format('Y-m-d') }}" required>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="case_id">Case</label>
                                        <select class="form-control select2" id="case_id" name="case_id" required {{ $application->status !== 'pending' ? 'disabled' : '' }}>
                                            <option value="">Select Case</option>
                                            @foreach($cases as $case)
                                                <option value="{{ $case->id }}" {{ $application->case_id == $case->id ? 'selected' : '' }}>
                                                    {{ $case->case_number }} - {{ $case->title }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @if($application->status !== 'pending')
                                            <input type="hidden" name="case_id" value="{{ $application->case_id }}">
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="suspect_id">Suspect</label>
                                        <select class="form-control select2" id="suspect_id" name="suspect_id" required {{ $application->status !== 'pending' ? 'disabled' : '' }}>
                                            <option value="">Select Suspect</option>
                                            @foreach($suspects as $suspect)
                                                <option value="{{ $suspect->id }}" {{ $application->suspect_id == $suspect->id ? 'selected' : '' }}>
                                                    {{ $suspect->first_name }} {{ $suspect->last_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @if($application->status !== 'pending')
                                            <input type="hidden" name="suspect_id" value="{{ $application->suspect_id }}">
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="hearing_date">Hearing Date</label>
                                        <input type="date" class="form-control" id="hearing_date" name="hearing_date" value="{{ $application->hearing_date ? $application->hearing_date->format('Y-m-d') : '' }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="amount">Bail Amount (GMD)</label>
                                        <input type="number" step="0.01" class="form-control" id="amount" name="amount" value="{{ $application->amount }}">
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="reason">Reason for Bail</label>
                                <textarea class="form-control" id="reason" name="reason" rows="3" required>{{ $application->reason }}</textarea>
                            </div>

                            <div class="form-group">
                                <label for="notes">Additional Notes</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3">{{ $application->notes }}</textarea>
                            </div>
                        </div>
                    </div>

                    <!-- Bail Conditions -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Bail Conditions</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-primary btn-sm" id="addCondition">
                                    <i class="fas fa-plus"></i> Add Condition
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="conditions-container">
                                @if($application->conditions->count() > 0)
                                    @foreach($application->conditions as $index => $condition)
                                        <div class="condition-row mb-3 border-bottom pb-3">
                                            <div class="row">
                                                <div class="col-md-5">
                                                    <div class="form-group">
                                                        <label>Condition Type</label>
                                                        <select class="form-control" name="conditions[{{ $index }}][condition_type]" required>
                                                            <option value="">Select Type</option>
                                                            @foreach($conditionTypes as $value => $label)
                                                                <option value="{{ $value }}" {{ $condition->condition_type == $value ? 'selected' : '' }}>{{ $label }}</option>
                                                            @endforeach
                                                        </select>
                                                        <input type="hidden" name="conditions[{{ $index }}][id]" value="{{ $condition->id }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Description</label>
                                                        <textarea class="form-control" name="conditions[{{ $index }}][description]" rows="1" required>{{ $condition->description }}</textarea>
                                                    </div>
                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <label>&nbsp;</label>
                                                        <button type="button" class="btn btn-danger btn-block remove-condition">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="text-center text-muted py-3">
                                        <p>No conditions added yet. Click "Add Condition" to add bail conditions.</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <!-- Status Card -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Status</h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="status">Current Status</label>
                                <select class="form-control" id="status" name="status" {{ $application->status !== 'pending' ? 'disabled' : '' }}>
                                    <option value="pending" {{ $application->status === 'pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="approved" {{ $application->status === 'approved' ? 'selected' : '' }}>Approved</option>
                                    <option value="rejected" {{ $application->status === 'rejected' ? 'selected' : '' }}>Rejected</option>
                                    <option value="revoked" {{ $application->status === 'revoked' ? 'selected' : '' }}>Revoked</option>
                                </select>
                                @if($application->status !== 'pending')
                                    <input type="hidden" name="status" value="{{ $application->status }}">
                                    <small class="form-text text-muted">Status can only be changed from the details page once the application is no longer pending.</small>
                                @endif
                            </div>

                            <div id="approval-fields" style="{{ $application->status === 'approved' ? '' : 'display: none;' }}">
                                <div class="form-group">
                                    <label for="approval_date">Approval Date</label>
                                    <input type="date" class="form-control" id="approval_date" name="approval_date" value="{{ $application->approval_date ? $application->approval_date->format('Y-m-d') : '' }}" {{ $application->status === 'approved' && $application->status !== 'pending' ? 'readonly' : '' }}>
                                </div>
                                <div class="form-group">
                                    <label for="expiry_date">Expiry Date</label>
                                    <input type="date" class="form-control" id="expiry_date" name="expiry_date" value="{{ $application->expiry_date ? $application->expiry_date->format('Y-m-d') : '' }}" {{ $application->status === 'approved' && $application->status !== 'pending' ? 'readonly' : '' }}>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Surety Information -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Surety Information</h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="surety_name">Name</label>
                                <input type="text" class="form-control" id="surety_name" name="surety_name" value="{{ $application->surety_name }}">
                            </div>
                            <div class="form-group">
                                <label for="surety_contact">Contact</label>
                                <input type="text" class="form-control" id="surety_contact" name="surety_contact" value="{{ $application->surety_contact }}">
                            </div>
                            <div class="form-group">
                                <label for="surety_address">Address</label>
                                <textarea class="form-control" id="surety_address" name="surety_address" rows="2">{{ $application->surety_address }}</textarea>
                            </div>
                            <div class="form-group">
                                <label for="surety_relationship">Relationship to Suspect</label>
                                <input type="text" class="form-control" id="surety_relationship" name="surety_relationship" value="{{ $application->surety_relationship }}">
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="surety_id_type">ID Type</label>
                                        <select class="form-control" id="surety_id_type" name="surety_id_type">
                                            <option value="">Select ID Type</option>
                                            <option value="national_id" {{ $application->surety_id_type === 'national_id' ? 'selected' : '' }}>National ID</option>
                                            <option value="passport" {{ $application->surety_id_type === 'passport' ? 'selected' : '' }}>Passport</option>
                                            <option value="drivers_license" {{ $application->surety_id_type === 'drivers_license' ? 'selected' : '' }}>Driver's License</option>
                                            <option value="voter_card" {{ $application->surety_id_type === 'voter_card' ? 'selected' : '' }}>Voter's Card</option>
                                            <option value="other" {{ $application->surety_id_type === 'other' ? 'selected' : '' }}>Other</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="surety_id_number">ID Number</label>
                                        <input type="text" class="form-control" id="surety_id_number" name="surety_id_number" value="{{ $application->surety_id_number }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <button type="submit" class="btn btn-primary btn-block">Update Bail Application</button>
                            <a href="{{ route('bail.show', $application->id) }}" class="btn btn-default btn-block mt-2">Cancel</a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Condition Template (Hidden) -->
<template id="condition-template">
    <div class="condition-row mb-3 border-bottom pb-3">
        <div class="row">
            <div class="col-md-5">
                <div class="form-group">
                    <label>Condition Type</label>
                    <select class="form-control" name="conditions[INDEX][condition_type]" required>
                        <option value="">Select Type</option>
                        @foreach($conditionTypes as $value => $label)
                            <option value="{{ $value }}">{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Description</label>
                    <textarea class="form-control" name="conditions[INDEX][description]" rows="1" required></textarea>
                </div>
            </div>
            <div class="col-md-1">
                <div class="form-group">
                    <label>&nbsp;</label>
                    <button type="button" class="btn btn-danger btn-block remove-condition">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
</template>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
<script>
    $(document).ready(function() {
        // Initialize Select2
        $('.select2').select2();
        
        // Show/hide approval fields based on status
        $('#status').on('change', function() {
            if ($(this).val() === 'approved') {
                $('#approval-fields').show();
            } else {
                $('#approval-fields').hide();
            }
        });
        
        // Load suspects based on selected case
        $('#case_id').on('change', function() {
            var caseId = $(this).val();
            if (caseId) {
                $.ajax({
                    url: "{{ route('bail.get-suspects') }}",
                    type: "GET",
                    data: { case_id: caseId },
                    success: function(data) {
                        $('#suspect_id').empty();
                        $('#suspect_id').append('<option value="">Select Suspect</option>');
                        $.each(data, function(key, value) {
                            $('#suspect_id').append('<option value="' + value.id + '">' + value.name + '</option>');
                        });
                    }
                });
            } else {
                $('#suspect_id').empty();
                $('#suspect_id').append('<option value="">Select Suspect</option>');
            }
        });
        
        // Add new condition
        let conditionIndex = {{ $application->conditions->count() }};
        
        $('#addCondition').on('click', function() {
            let template = $('#condition-template').html();
            template = template.replace(/INDEX/g, conditionIndex);
            
            if ($('#conditions-container').find('.condition-row').length === 0) {
                $('#conditions-container').empty();
            }
            
            $('#conditions-container').append(template);
            conditionIndex++;
        });
        
        // Remove condition
        $(document).on('click', '.remove-condition', function() {
            $(this).closest('.condition-row').remove();
            
            if ($('#conditions-container').find('.condition-row').length === 0) {
                $('#conditions-container').html('<div class="text-center text-muted py-3"><p>No conditions added yet. Click "Add Condition" to add bail conditions.</p></div>');
            }
        });
        
        // Enable tooltips
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>
@stop
