@extends('adminlte::page')

@section('title', 'Bail Applications')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Bail Applications</h1>
        <a href="{{ route('bail.create') }}" class="btn btn-primary"><i class="fas fa-plus"></i> New Bail Application</a>
    </div>
@stop

@section('content')

<div class="row">
    <div class="col-md-12">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                {{ session('success') }}
            </div>
        @endif

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Filter Bail Applications</h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('bail.index') }}" method="GET">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Case</label>
                                <select name="case_id" class="form-control select2">
                                    <option value="">All Cases</option>
                                    @foreach($cases as $case)
                                        <option value="{{ $case->id }}" {{ request('case_id') == $case->id ? 'selected' : '' }}>
                                            {{ $case->case_number }} - {{ $case->title }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Suspect</label>
                                <select name="suspect_id" class="form-control select2">
                                    <option value="">All Suspects</option>
                                    @foreach($suspects as $suspect)
                                        <option value="{{ $suspect->id }}" {{ request('suspect_id') == $suspect->id ? 'selected' : '' }}>
                                            {{ $suspect->first_name }} {{ $suspect->last_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Status</label>
                                <select name="status" class="form-control">
                                    <option value="">All Statuses</option>
                                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                                    <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                                    <option value="revoked" {{ request('status') == 'revoked' ? 'selected' : '' }}>Revoked</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Application Date (From)</label>
                                <input type="date" name="application_date_from" class="form-control" value="{{ request('application_date_from') }}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Application Date (To)</label>
                                <input type="date" name="application_date_to" class="form-control" value="{{ request('application_date_to') }}">
                            </div>
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                                <a href="{{ route('bail.index') }}" class="btn btn-default">
                                    <i class="fas fa-sync"></i> Reset
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Bail Applications List</h3>
            </div>
            <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th>Application #</th>
                            <th>Case</th>
                            <th>Suspect</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Amount</th>
                            <th>Expiry Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($applications as $application)
                            <tr>
                                <td>{{ $application->application_number }}</td>
                                <td>
                                    @if($application->case)
                                        <a href="{{ route('cases.show', $application->case->id) }}">
                                            {{ $application->case->case_number }}
                                        </a>
                                    @else
                                        <span class="text-muted">N/A</span>
                                    @endif
                                </td>
                                <td>
                                    @if($application->suspect)
                                        <a href="{{ route('case-suspects.show', $application->suspect->id) }}">
                                            {{ $application->suspect->first_name }} {{ $application->suspect->last_name }}
                                        </a>
                                    @else
                                        <span class="text-muted">N/A</span>
                                    @endif
                                </td>
                                <td>{{ $application->application_date->format('d/m/Y') }}</td>
                                <td>{!! $application->status_badge !!}</td>
                                <td>
                                    @if($application->amount)
                                        GMD {{ number_format($application->amount, 2) }}
                                    @else
                                        <span class="text-muted">N/A</span>
                                    @endif
                                </td>
                                <td>
                                    @if($application->expiry_date)
                                        {{ $application->expiry_date->format('d/m/Y') }}
                                        @if($application->expiry_date->isPast() && $application->status === 'approved')
                                            <span class="badge badge-danger">Expired</span>
                                        @endif
                                    @else
                                        <span class="text-muted">N/A</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('bail.show', $application->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('bail.edit', $application->id) }}" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#delete-modal-{{ $application->id }}">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                    
                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="delete-modal-{{ $application->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $application->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteModalLabel{{ $application->id }}">Confirm Delete</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Are you sure you want to delete bail application <strong>{{ $application->application_number }}</strong>? This action cannot be undone.
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                    <form action="{{ route('bail.destroy', $application->id) }}" method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger">Delete</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center">No bail applications found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="card-footer clearfix">
                {{ $applications->appends(request()->query())->links() }}
            </div>
        </div>
    </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            $('.select2').select2();
            // Enable tooltips
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
@stop
