@extends('adminlte::page')

@section('title', 'Bail Application Details')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Bail Application Details</h1>
        <div>
            <a href="{{ route('bail.index') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back to List</a>
            @if($application->status === 'pending')
                <a href="{{ route('bail.edit', $application->id) }}" class="btn btn-warning"><i class="fas fa-edit"></i> Edit</a>
                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal">
                    <i class="fas fa-trash"></i> Delete
                </button>
            @endif
        </div>
    </div>
@stop

@section('content')

<div class="row">
    <div class="col-md-12">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                {{ session('success') }}
            </div>
        @endif

        <div class="row">
            <div class="col-md-8">
                <!-- Basic Information -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            Application #{{ $application->application_number }}
                            <span class="ml-2">{!! $application->status_badge !!}</span>
                        </h3>
                        <div class="card-tools">
                            @if($application->status === 'pending')
                                <a href="{{ route('bail.edit', $application->id) }}" class="btn btn-warning btn-sm">
                                    <i class="fas fa-edit mr-1"></i> Edit
                                </a>
                                <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal">
                                    <i class="fas fa-trash mr-1"></i> Delete
                                </button>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Application Info -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-box bg-light">
                                    <div class="info-box-content">
                                        <span class="info-box-text text-muted">Case</span>
                                        <span class="info-box-number text-muted">
                                            @if($application->case)
                                                <a href="{{ route('cases.show', $application->case_id) }}">
                                                    {{ $application->case->case_number }} - {{ $application->case->title }}
                                                </a>
                                            @else
                                                <span class="text-danger">No case associated</span>
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-box bg-light">
                                    <div class="info-box-content">
                                        <span class="info-box-text text-muted">Suspect</span>
                                        <span class="info-box-number text-muted">
                                            @if($application->suspect)
                                                <a href="{{ route('case-suspects.show', $application->suspect_id) }}">
                                                    {{ $application->suspect->first_name }} {{ $application->suspect->last_name }}
                                                </a>
                                            @else
                                                <span class="text-danger">No suspect associated</span>
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Application Dates -->
                        <div class="row mt-3">
                            <div class="col-md-4">
                                <div class="info-box bg-light">
                                    <div class="info-box-content">
                                        <span class="info-box-text text-muted">Application Date</span>
                                        <span class="info-box-number text-muted">
                                            {{ $application->application_date->format('d/m/Y') }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="info-box bg-light">
                                    <div class="info-box-content">
                                        <span class="info-box-text text-muted">Approval Date</span>
                                        <span class="info-box-number text-muted">
                                            {{ $application->approval_date ? $application->approval_date->format('d/m/Y') : 'N/A' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="info-box bg-light">
                                    <div class="info-box-content">
                                        <span class="info-box-text text-muted">Expiry Date</span>
                                        <span class="info-box-number text-muted">
                                            @if($application->expiry_date)
                                                {{ $application->expiry_date->format('d/m/Y') }}
                                                @if($application->expiry_date->isPast() && $application->status === 'approved')
                                                    <span class="badge badge-danger">Expired</span>
                                                @endif
                                            @else
                                                N/A
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Amount and Approval -->
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="info-box bg-light">
                                    <div class="info-box-content">
                                        <span class="info-box-text text-muted">Bail Amount</span>
                                        <span class="info-box-number text-muted">
                                            {{ $application->amount ? 'GMD ' . number_format($application->amount, 2) : 'N/A' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-box bg-light">
                                    <div class="info-box-content">
                                        <span class="info-box-text text-muted">Approved By</span>
                                        <span class="info-box-number text-muted">
                                            {{ $application->approvedBy ? $application->approvedBy->name : 'N/A' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Reason and Notes -->
                        <div class="form-group mt-3">
                            <label>Reason for Bail Application</label>
                            <div class="p-3 bg-light rounded">
                                {{ $application->reason ?? 'No reason provided' }}
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label>Additional Notes</label>
                            <div class="p-3 bg-light rounded">
                                {!! nl2br(e($application->notes ?? 'No additional notes')) !!}
                            </div>
                        </div>
                        
                        <!-- User Tracking -->
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="info-box bg-light">
                                    <div class="info-box-content">
                                        <span class="info-box-text text-muted">Created By</span>
                                        <span class="info-box-number text-muted">
                                            {{ $application->createdByUser ? $application->createdByUser->name : 'N/A' }}
                                            on {{ $application->created_at->format('d/m/Y H:i') }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-box bg-light">
                                    <div class="info-box-content">
                                        <span class="info-box-text text-muted">Last Updated By</span>
                                        <span class="info-box-number text-muted">
                                            {{ $application->updatedByUser ? $application->updatedByUser->name : 'N/A' }}
                                            on {{ $application->updated_at->format('d/m/Y H:i') }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Bail Conditions -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Bail Conditions</h3>
                        @if($application->status === 'approved')
                            <div class="card-tools">
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addConditionModal">
                                    <i class="fas fa-plus"></i> Add Condition
                                </button>
                            </div>
                        @endif
                    </div>
                    <div class="card-body p-0">
                        @if($application->conditions->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Type</th>
                                            <th>Description</th>
                                            <th>Status</th>
                                            <th>Fulfilled Date</th>
                                            <th>Verified By</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($application->conditions as $condition)
                                            <tr>
                                                <td>
                                                    @php
                                                        $conditionTypes = App\Models\BailCondition::getConditionTypes();
                                                        $conditionLabel = $conditionTypes[$condition->condition_type] ?? $condition->condition_type;
                                                    @endphp
                                                    {{ $conditionLabel }}
                                                </td>
                                                <td>{{ $condition->description }}</td>
                                                <td>{!! $condition->status_badge !!}</td>
                                                <td>{{ $condition->fulfillment_date ? $condition->fulfillment_date->format('d/m/Y') : 'N/A' }}</td>
                                                <td>{{ $condition->verifiedBy ? $condition->verifiedBy->name : 'N/A' }}</td>
                                                <td>
                                                    <button type="button" class="btn btn-info btn-sm" data-toggle="modal" data-target="#conditionModal{{ $condition->id }}">
                                                        <i class="fas fa-check"></i> Update
                                                    </button>
                                                </td>
                                            </tr>
                                            
                                            <!-- Condition Update Modal -->
                                            <div class="modal fade" id="conditionModal{{ $condition->id }}">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <form action="{{ route('bail.update-condition', $condition->id) }}" method="POST">
                                                            @csrf
                                                            @method('PATCH')
                                                            <div class="modal-header">
                                                                <h4 class="modal-title">Update Condition Status</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label>Condition Type</label>
                                                                    <input type="text" class="form-control" value="{{ $conditionLabel }}" readonly>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label>Description</label>
                                                                    <textarea class="form-control" rows="2" readonly>{{ $condition->description }}</textarea>
                                                                </div>
                                                                <div class="form-group">
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input" id="is_fulfilled{{ $condition->id }}" name="is_fulfilled" value="1" {{ $condition->is_fulfilled ? 'checked' : '' }}>
                                                                        <label class="custom-control-label" for="is_fulfilled{{ $condition->id }}">Mark as Fulfilled</label>
                                                                    </div>
                                                                </div>
                                                                <div class="fulfillment-details" style="{{ $condition->is_fulfilled ? '' : 'display: none;' }}">
                                                                    <div class="form-group">
                                                                        <label>Fulfillment Date</label>
                                                                        <input type="date" class="form-control" name="fulfillment_date" value="{{ $condition->fulfillment_date ? $condition->fulfillment_date->format('Y-m-d') : now()->format('Y-m-d') }}">
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label>Fulfillment Notes</label>
                                                                        <textarea class="form-control" name="fulfillment_notes" rows="2">{{ $condition->fulfillment_notes }}</textarea>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label>Verified By</label>
                                                                        <select class="form-control" name="verified_by">
                                                                            <option value="">Select Officer</option>
                                                                            @foreach($officers as $officer)
                                                                                <option value="{{ $officer->id }}" {{ $condition->verified_by == $officer->id ? 'selected' : '' }}>{{ $officer->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer justify-content-between">
                                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                <button type="submit" class="btn btn-primary">Save Changes</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="p-3 text-center text-muted">
                                No conditions have been set for this bail application.
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <!-- Status Update Card -->
                @if($application->status === 'pending')
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Update Status</h3>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('bail.update-status', $application->id) }}" method="POST">
                                @csrf
                                @method('PATCH')
                                <div class="form-group">
                                    <label>Status</label>
                                    <select class="form-control" name="status" id="status-update">
                                        <option value="pending" {{ $application->status === 'pending' ? 'selected' : '' }}>Pending</option>
                                        <option value="approved" {{ $application->status === 'approved' ? 'selected' : '' }}>Approved</option>
                                        <option value="rejected" {{ $application->status === 'rejected' ? 'selected' : '' }}>Rejected</option>
                                        <option value="revoked" {{ $application->status === 'revoked' ? 'selected' : '' }}>Revoked</option>
                                    </select>
                                </div>
                                
                                <div class="approval-fields" style="display: none;">
                                    <div class="form-group">
                                        <label>Approval Date</label>
                                        <input type="date" class="form-control" name="approval_date" value="{{ now()->format('Y-m-d') }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Expiry Date</label>
                                        <input type="date" class="form-control" name="expiry_date" value="{{ now()->addMonths(3)->format('Y-m-d') }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Approved By</label>
                                        <select class="form-control" name="approved_by">
                                            <option value="">Select Officer</option>
                                            @foreach($officers as $officer)
                                                <option value="{{ $officer->id }}">{{ $officer->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea class="form-control" name="notes" rows="3"></textarea>
                                </div>
                                
                                <button type="submit" class="btn btn-primary btn-block">Update Status</button>
                            </form>
                        </div>
                    </div>
                @endif
                
                <!-- Surety Information -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Surety Information</h3>
                    </div>
                    <div class="card-body">
                        @if($application->surety_name)
                            <dl>
                                <dt>Name</dt>
                                <dd>{{ $application->surety_name }}</dd>
                                
                                <dt>Contact</dt>
                                <dd>{{ $application->surety_contact ?? 'N/A' }}</dd>
                                
                                <dt>Address</dt>
                                <dd>{{ $application->surety_address ?? 'N/A' }}</dd>
                                
                                <dt>Relationship to Suspect</dt>
                                <dd>{{ $application->surety_relationship ?? 'N/A' }}</dd>
                                
                                <dt>ID Type</dt>
                                <dd>
                                    @php
                                        $idTypes = [
                                            'national_id' => 'National ID',
                                            'passport' => 'Passport',
                                            'drivers_license' => "Driver's License",
                                            'voter_card' => "Voter's Card",
                                            'other' => 'Other'
                                        ];
                                    @endphp
                                    {{ $idTypes[$application->surety_id_type] ?? $application->surety_id_type ?? 'N/A' }}
                                </dd>
                                
                                <dt>ID Number</dt>
                                <dd>{{ $application->surety_id_number ?? 'N/A' }}</dd>
                            </dl>
                        @else
                            <p class="text-muted">No surety information provided.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Delete Modal -->
        <div class="modal fade" id="deleteModal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Delete Bail Application</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to delete this bail application?</p>
                        <p class="text-danger">This action cannot be undone.</p>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <form action="{{ route('bail.destroy', $application->id) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">Delete</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Add Condition Modal -->
        <div class="modal fade" id="addConditionModal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('bail.store') }}" method="POST">
                        @csrf
                        <input type="hidden" name="bail_application_id" value="{{ $application->id }}">
                        <div class="modal-header">
                            <h4 class="modal-title">Add Bail Condition</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Condition Type</label>
                                <select class="form-control" name="condition_type">
                                    <option value="">Select Type</option>
                                    @foreach(App\Models\BailCondition::getConditionTypes() as $value => $label)
                                        <option value="{{ $value }}">{{ $label }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Description</label>
                                <textarea class="form-control" name="description" rows="3"></textarea>
                            </div>
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Add Condition</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
<script>
    $(document).ready(function() {
        // Show/hide approval fields based on status
        $('#status-update').on('change', function() {
            if ($(this).val() === 'approved') {
                $('.approval-fields').show();
            } else {
                $('.approval-fields').hide();
            }
        });
        
        // Initialize status
        if ($('#status-update').val() === 'approved') {
            $('.approval-fields').show();
        }
        
        // Show/hide fulfillment details
        $('input[name="is_fulfilled"]').on('change', function() {
            if ($(this).is(':checked')) {
                $(this).closest('.modal-body').find('.fulfillment-details').show();
            } else {
                $(this).closest('.modal-body').find('.fulfillment-details').hide();
            }
        });
        
        // Enable tooltips
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>
@stop
