@extends('adminlte::page')

@section('title', 'Add New Evidence')

@section('content_header')
    <h1>Add New Evidence</h1>
@stop

@section('content')
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('case-evidences.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="case_id">Case <span class="text-danger">*</span></label>
                            <select class="form-control @error('case_id') is-invalid @enderror" id="case_id" name="case_id" required>
                                <option value="">-- Select Case --</option>
                                @foreach($cases as $case)
                                    <option value="{{ $case->id }}" {{ (old('case_id') == $case->id || (isset($preselectedCase) && $preselectedCase->id == $case->id)) ? 'selected' : '' }}>
                                        #{{ $case->case_number }} - {{ $case->title }}
                                    </option>
                                @endforeach
                            </select>
                            @error('case_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="tag_number">Evidence Tag Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('tag_number') is-invalid @enderror" id="tag_number" name="tag_number" value="{{ old('tag_number', $nextTagNumber ?? '') }}" required>
                            <small class="form-text text-muted">Unique identifier for this evidence item</small>
                            @error('tag_number')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Evidence Name/Description <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
                            @error('name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="evidence_type">Evidence Type <span class="text-danger">*</span></label>
                            <select class="form-control @error('evidence_type') is-invalid @enderror" id="evidence_type" name="evidence_type" required>
                                <option value="">-- Select Type --</option>
                                <option value="physical" {{ old('evidence_type') == 'physical' ? 'selected' : '' }}>Physical</option>
                                <option value="digital" {{ old('evidence_type') == 'digital' ? 'selected' : '' }}>Digital</option>
                                <option value="documentary" {{ old('evidence_type') == 'documentary' ? 'selected' : '' }}>Documentary</option>
                                <option value="biological" {{ old('evidence_type') == 'biological' ? 'selected' : '' }}>Biological</option>
                                <option value="forensic" {{ old('evidence_type') == 'forensic' ? 'selected' : '' }}>Forensic</option>
                                <option value="other" {{ old('evidence_type') == 'other' ? 'selected' : '' }}>Other</option>
                            </select>
                            @error('evidence_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <h4 class="mt-4">Collection Details</h4>
                <hr>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="collection_datetime">Collection Date <span class="text-danger">*</span></label>
                            <input type="date" class="form-control @error('collection_datetime') is-invalid @enderror" id="collection_datetime" name="collection_datetime" value="{{ old('collection_datetime', date('Y-m-d')) }}" required>
                            @error('collection_datetime')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="collection_time">Collection Time</label>
                            <input type="time" class="form-control @error('collection_time') is-invalid @enderror" id="collection_time" name="collection_time" value="{{ old('collection_time') }}">
                            @error('collection_time')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="collected_by">Collected By <span class="text-danger">*</span></label>
                            <select class="form-control @error('collected_by') is-invalid @enderror" id="collected_by" name="collected_by" required>
                                <option value="">-- Select Officer --</option>
                                @foreach($officers as $officer)
                                    <option value="{{ $officer->id }}" {{ old('collected_by') == $officer->id ? 'selected' : '' }}>
                                        {{ $officer->name }} ({{ $officer->badge_number }})
                                    </option>
                                @endforeach
                            </select>
                            @error('collected_by')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="collection_location">Collection Location <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('collection_location') is-invalid @enderror" id="collection_location" name="collection_location" value="{{ old('collection_location') }}" required>
                            @error('collection_location')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="collection_details">Collection Details</label>
                            <textarea class="form-control @error('collection_details') is-invalid @enderror" id="collection_details" name="collection_details" rows="3">{{ old('collection_details') }}</textarea>
                            <small class="form-text text-muted">Describe how the evidence was collected and any relevant circumstances</small>
                            @error('collection_details')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <h4 class="mt-4">Storage Information</h4>
                <hr>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="status">Current Status <span class="text-danger">*</span></label>
                            <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                <option value="">-- Select Status --</option>
                                <option value="collected" {{ old('status', 'collected') == 'collected' ? 'selected' : '' }}>Collected</option>
                                <option value="in_storage" {{ old('status') == 'in_storage' ? 'selected' : '' }}>In Storage</option>
                                <option value="in_analysis" {{ old('status') == 'in_analysis' ? 'selected' : '' }}>In Analysis</option>
                                <option value="analyzed" {{ old('status') == 'analyzed' ? 'selected' : '' }}>Analyzed</option>
                                <option value="returned" {{ old('status') == 'returned' ? 'selected' : '' }}>Returned</option>
                                <option value="destroyed" {{ old('status') == 'destroyed' ? 'selected' : '' }}>Destroyed</option>
                            </select>
                            @error('status')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="storage_location">Storage Location <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('storage_location') is-invalid @enderror" id="storage_location" name="storage_location" value="{{ old('storage_location') }}" required>
                            <small class="form-text text-muted">Where the evidence is currently stored (e.g., Evidence Room B, Shelf 3)</small>
                            @error('storage_location')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="condition">Condition</label>
                            <select class="form-control @error('condition') is-invalid @enderror" id="condition" name="condition">
                                <option value="">-- Select Condition --</option>
                                <option value="excellent" {{ old('condition') == 'excellent' ? 'selected' : '' }}>Excellent</option>
                                <option value="good" {{ old('condition', 'good') == 'good' ? 'selected' : '' }}>Good</option>
                                <option value="fair" {{ old('condition') == 'fair' ? 'selected' : '' }}>Fair</option>
                                <option value="poor" {{ old('condition') == 'poor' ? 'selected' : '' }}>Poor</option>
                                <option value="damaged" {{ old('condition') == 'damaged' ? 'selected' : '' }}>Damaged</option>
                            </select>
                            @error('condition')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="custodian">Current Custodian</label>
                            <input type="text" class="form-control @error('custodian') is-invalid @enderror" id="custodian" name="custodian" value="{{ old('custodian') }}">
                            <small class="form-text text-muted">Person currently responsible for the evidence</small>
                            @error('custodian')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <h4 class="mt-4">Evidence Documentation</h4>
                <hr>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="photos">Evidence Photos</label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('photos') is-invalid @enderror" id="photos" name="photos[]" multiple>
                                    <label class="custom-file-label" for="photos">Choose files</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Multiple files allowed. Accepted formats: JPG, PNG. Max size: 10MB total</small>
                            @error('photos')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="documents">Related Documents</label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('documents') is-invalid @enderror" id="documents" name="documents[]" multiple>
                                    <label class="custom-file-label" for="documents">Choose files</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Multiple files allowed. Accepted formats: PDF, DOC, DOCX. Max size: 10MB total</small>
                            @error('documents')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="notes">Additional Notes</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-12">
                        <a href="{{ url()->previous() }}" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary float-right">Add Evidence</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Update file input label with selected filename
            $('.custom-file-input').on('change', function() {
                let fileName = $(this).val().split('\\').pop();
                if ($(this).attr('multiple')) {
                    let fileCount = $(this)[0].files.length;
                    if (fileCount > 1) {
                        $(this).next('.custom-file-label').addClass("selected").html(fileCount + " files selected");
                    } else {
                        $(this).next('.custom-file-label').addClass("selected").html(fileName);
                    }
                } else {
                    $(this).next('.custom-file-label').addClass("selected").html(fileName);
                }
            });
            
            // Additional form logic can be added here
        });
    </script>
@stop
