@extends('adminlte::page')

@section('title', 'Case Evidences')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Case Evidences</h1>
        <a href="{{ route('case-evidences.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Evidence
        </a>
    </div>
@stop

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Filter Evidences</h3>
            <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <form action="{{ route('case-evidences.index') }}" method="GET">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="case_id">Case</label>
                            <select class="form-control" id="case_id" name="case_id">
                                <option value="">All Cases</option>
                                @foreach($cases as $case)
                                    <option value="{{ $case->id }}" {{ request('case_id') == $case->id ? 'selected' : '' }}>
                                        #{{ $case->case_number }} - {{ $case->title }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="evidence_type">Evidence Type</label>
                            <select class="form-control" id="evidence_type" name="evidence_type">
                                <option value="">All Types</option>
                                <option value="physical" {{ request('evidence_type') == 'physical' ? 'selected' : '' }}>Physical</option>
                                <option value="digital" {{ request('evidence_type') == 'digital' ? 'selected' : '' }}>Digital</option>
                                <option value="documentary" {{ request('evidence_type') == 'documentary' ? 'selected' : '' }}>Documentary</option>
                                <option value="biological" {{ request('evidence_type') == 'biological' ? 'selected' : '' }}>Biological</option>
                                <option value="forensic" {{ request('evidence_type') == 'forensic' ? 'selected' : '' }}>Forensic</option>
                                <option value="other" {{ request('evidence_type') == 'other' ? 'selected' : '' }}>Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" id="status" name="status">
                                <option value="">All Statuses</option>
                                <option value="collected" {{ request('status') == 'collected' ? 'selected' : '' }}>Collected</option>
                                <option value="in_storage" {{ request('status') == 'in_storage' ? 'selected' : '' }}>In Storage</option>
                                <option value="in_analysis" {{ request('status') == 'in_analysis' ? 'selected' : '' }}>In Analysis</option>
                                <option value="analyzed" {{ request('status') == 'analyzed' ? 'selected' : '' }}>Analyzed</option>
                                <option value="returned" {{ request('status') == 'returned' ? 'selected' : '' }}>Returned</option>
                                <option value="destroyed" {{ request('status') == 'destroyed' ? 'selected' : '' }}>Destroyed</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="collected_by">Collected By</label>
                            <select class="form-control" id="collected_by" name="collected_by">
                                <option value="">All Officers</option>
                                @foreach($officers as $officer)
                                    <option value="{{ $officer->id }}" {{ request('collected_by') == $officer->id ? 'selected' : '' }}>
                                        {{ $officer->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="start_date">Collection Date (From)</label>
                            <input type="date" class="form-control" id="start_date" name="start_date" value="{{ request('start_date') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="end_date">Collection Date (To)</label>
                            <input type="date" class="form-control" id="end_date" name="end_date" value="{{ request('end_date') }}">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="search">Search</label>
                            <input type="text" class="form-control" id="search" name="search" placeholder="Search by evidence name, tag number, location..." value="{{ request('search') }}">
                        </div>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <div class="form-group w-100">
                            <button type="submit" class="btn btn-primary mr-2">
                                <i class="fas fa-search"></i> Filter
                            </button>
                            <a href="{{ route('case-evidences.index') }}" class="btn btn-secondary">
                                <i class="fas fa-sync"></i> Reset
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Evidence List</h3>
        </div>
        <div class="card-body">
            @if($evidences->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Tag #</th>
                                <th>Case</th>
                                <th>Name/Description</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Collection Date</th>
                                <th>Location</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($evidences as $evidence)
                                <tr>
                                    <td>{{ $evidence->tag_number }}</td>
                                    <td>
                                        <a href="{{ route('cases.show', $evidence->case_id) }}">
                                            #{{ $evidence->case->case_number }}
                                        </a>
                                    </td>
                                    <td>{{ $evidence->name }}</td>
                                    <td>
                                        @switch($evidence->evidence_type)
                                            @case('physical')
                                                <span class="badge badge-primary">Physical</span>
                                                @break
                                            @case('digital')
                                                <span class="badge badge-info">Digital</span>
                                                @break
                                            @case('documentary')
                                                <span class="badge badge-secondary">Documentary</span>
                                                @break
                                            @case('biological')
                                                <span class="badge badge-danger">Biological</span>
                                                @break
                                            @case('forensic')
                                                <span class="badge badge-warning">Forensic</span>
                                                @break
                                            @default
                                                <span class="badge badge-dark">{{ ucfirst($evidence->evidence_type) }}</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        @switch($evidence->status)
                                            @case('collected')
                                                <span class="badge badge-info">Collected</span>
                                                @break
                                            @case('in_storage')
                                                <span class="badge badge-primary">In Storage</span>
                                                @break
                                            @case('in_analysis')
                                                <span class="badge badge-warning">In Analysis</span>
                                                @break
                                            @case('analyzed')
                                                <span class="badge badge-success">Analyzed</span>
                                                @break
                                            @case('returned')
                                                <span class="badge badge-secondary">Returned</span>
                                                @break
                                            @case('destroyed')
                                                <span class="badge badge-danger">Destroyed</span>
                                                @break
                                            @default
                                                <span class="badge badge-dark">{{ ucfirst(str_replace('_', ' ', $evidence->status)) }}</span>
                                        @endswitch
                                    </td>
                                    <td>{{ $evidence->collection_datetime ? $evidence->collection_datetime->format('d M Y') : 'N/A' }}</td>
                                    <td>{{ $evidence->storage_location }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('case-evidences.show', $evidence->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('case-evidences.edit', $evidence->id) }}" class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $evidence->id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                        
                                        <!-- Delete Modal -->
                                        <div class="modal fade" id="deleteModal{{ $evidence->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $evidence->id }}" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="deleteModalLabel{{ $evidence->id }}">Delete Evidence</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Are you sure you want to delete evidence <strong>{{ $evidence->name }}</strong> (Tag #{{ $evidence->tag_number }})?
                                                        <p class="text-danger mt-2">This action cannot be undone and will permanently delete all associated files and records.</p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                        <form action="{{ route('case-evidences.destroy', $evidence->id) }}" method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger">Delete Evidence</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <div class="mt-4">
                    {{ $evidences->appends(request()->query())->links() }}
                </div>
            @else
                <div class="alert alert-info">
                    No evidence records found. 
                    @if(request()->has('case_id') || request()->has('evidence_type') || request()->has('status') || request()->has('collected_by') || request()->has('search'))
                        <a href="{{ route('case-evidences.index') }}">Clear all filters</a> to see all records.
                    @else
                        <a href="{{ route('case-evidences.create') }}">Add a new evidence record</a> to get started.
                    @endif
                </div>
            @endif
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Any additional JS can go here
        });
    </script>
@stop
