@extends('adminlte::page')

@section('title', 'View Evidence')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Evidence Details</h1>
        <div>
            <a href="{{ route('case-evidences.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Evidence List
            </a>
            <a href="{{ route('case-evidences.edit', $evidence->id) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal">
                <i class="fas fa-trash"></i> Delete
            </button>
        </div>
    </div>
@stop

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Evidence Information</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Case</label>
                                <p>
                                    <a href="{{ route('cases.show', $evidence->case_id) }}">
                                        #{{ $evidence->case->case_number }} - {{ $evidence->case->title }}
                                    </a>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Tag Number</label>
                                <p><strong>{{ $evidence->tag_number }}</strong></p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Evidence Name/Description</label>
                                <p>{{ $evidence->name }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Evidence Type</label>
                                <p>
                                    @switch($evidence->evidence_type)
                                        @case('physical')
                                            <span class="badge badge-primary">Physical</span>
                                            @break
                                        @case('digital')
                                            <span class="badge badge-info">Digital</span>
                                            @break
                                        @case('documentary')
                                            <span class="badge badge-secondary">Documentary</span>
                                            @break
                                        @case('biological')
                                            <span class="badge badge-danger">Biological</span>
                                            @break
                                        @case('forensic')
                                            <span class="badge badge-warning">Forensic</span>
                                            @break
                                        @default
                                            <span class="badge badge-dark">{{ ucfirst($evidence->evidence_type) }}</span>
                                    @endswitch
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    <h5>Collection Details</h5>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Collection Date</label>
                                <p>{{ $evidence->collection_datetime ? $evidence->collection_datetime->format('d M Y') : 'N/A' }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Collection Time</label>
                                <p>{{ $evidence->collection_time ? $evidence->collection_time->format('h:i A') : 'Not specified' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Collected By</label>
                                <p>{{ $evidence->collector->name ?? 'Unknown' }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Collection Location</label>
                                <p>{{ $evidence->collection_location }}</p>
                            </div>
                        </div>
                    </div>
                    
                    @if($evidence->collection_details)
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Collection Details</label>
                                    <div class="p-3 bg-light" style="border-radius: 5px;">{{ $evidence->collection_details }}</div>
                                </div>
                            </div>
                        </div>
                    @endif
                    
                    <hr>
                    <h5>Storage Information</h5>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Current Status</label>
                                <p>
                                    @switch($evidence->status)
                                        @case('collected')
                                            <span class="badge badge-info">Collected</span>
                                            @break
                                        @case('in_storage')
                                            <span class="badge badge-primary">In Storage</span>
                                            @break
                                        @case('in_analysis')
                                            <span class="badge badge-warning">In Analysis</span>
                                            @break
                                        @case('analyzed')
                                            <span class="badge badge-success">Analyzed</span>
                                            @break
                                        @case('returned')
                                            <span class="badge badge-secondary">Returned</span>
                                            @break
                                        @case('destroyed')
                                            <span class="badge badge-danger">Destroyed</span>
                                            @break
                                        @default
                                            <span class="badge badge-dark">{{ ucfirst(str_replace('_', ' ', $evidence->status)) }}</span>
                                    @endswitch
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Storage Location</label>
                                <p>{{ $evidence->storage_location }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Condition</label>
                                <p>{{ ucfirst($evidence->condition ?? 'Not specified') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Current Custodian</label>
                                <p>{{ $evidence->custodian ?? 'Not specified' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    @if($evidence->notes)
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Additional Notes</label>
                                    <div class="p-3 bg-light" style="border-radius: 5px;">{{ $evidence->notes }}</div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
            
            @if($evidence->chain_of_custody && is_array($evidence->chain_of_custody) && count($evidence->chain_of_custody) > 0)
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Chain of Custody</h3>
                    </div>
                    <div class="card-body p-0">
                        <div class="timeline timeline-inverse p-3">
                            @foreach($evidence->chain_of_custody as $custody)
                                <div class="time-label">
                                    <span class="bg-primary">{{ $custody['date'] ?? 'Unknown Date' }}</span>
                                </div>
                                <div>
                                    <i class="fas fa-exchange-alt bg-primary"></i>
                                    <div class="timeline-item">
                                        <span class="time"><i class="far fa-clock"></i> {{ $custody['time'] ?? 'Unknown Time' }}</span>
                                        <h3 class="timeline-header">Transfer</h3>
                                        <div class="timeline-body">
                                            <p><strong>From:</strong> {{ $custody['from'] ?? 'Unknown' }}</p>
                                            <p><strong>To:</strong> {{ $custody['to'] ?? 'Unknown' }}</p>
                                            @if(isset($custody['reason']))
                                                <p><strong>Reason:</strong> {{ $custody['reason'] }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Related Information</h3>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Added On</label>
                        <p>{{ $evidence->created_at->format('d M Y, h:i A') }}</p>
                    </div>
                    
                    <div class="form-group">
                        <label>Last Updated</label>
                        <p>{{ $evidence->updated_at->format('d M Y, h:i A') }}</p>
                    </div>
                    
                    <div class="form-group">
                        <label>Added By</label>
                        <p>{{ $evidence->created_by_user->name ?? 'Unknown' }}</p>
                    </div>
                    
                    <hr>
                    
                    <div class="form-group">
                        <a href="{{ route('cases.show', $evidence->case_id) }}" class="btn btn-info btn-block">
                            <i class="fas fa-folder-open"></i> View Full Case
                        </a>
                    </div>
                    
                    <div class="form-group">
                        <button type="button" class="btn btn-primary btn-block" data-toggle="modal" data-target="#transferModal">
                            <i class="fas fa-exchange-alt"></i> Record Transfer
                        </button>
                    </div>
                </div>
            </div>
            
            @if($evidence->photos && is_array($evidence->photos) && count($evidence->photos) > 0)
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Evidence Photos</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach($evidence->photos as $photo)
                                <div class="col-md-6 mb-3">
                                    <a href="{{ asset('storage/' . $photo) }}" target="_blank">
                                        <img src="{{ asset('storage/' . $photo) }}" alt="Evidence Photo" class="img-fluid img-thumbnail">
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif
            
            @if($evidence->documents && is_array($evidence->documents) && count($evidence->documents) > 0)
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Related Documents</h3>
                    </div>
                    <div class="card-body">
                        <ul class="list-group">
                            @foreach($evidence->documents as $document)
                                <li class="list-group-item">
                                    <a href="{{ asset('storage/' . $document) }}" target="_blank">
                                        <i class="far fa-file-pdf"></i> {{ basename($document) }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Delete Evidence</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete evidence <strong>{{ $evidence->name }}</strong> (Tag #{{ $evidence->tag_number }})?
                    <p class="text-danger mt-2">This action cannot be undone and will permanently delete all associated files and records.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <form action="{{ route('case-evidences.destroy', $evidence->id) }}" method="POST" style="display: inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Delete Evidence</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Transfer Modal -->
    <div class="modal fade" id="transferModal" tabindex="-1" role="dialog" aria-labelledby="transferModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="transferModalLabel">Record Evidence Transfer</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('evidence-transfers.store') }}" method="POST">
                    @csrf
                    <input type="hidden" name="evidence_id" value="{{ $evidence->id }}">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="from_person">From Person</label>
                            <input type="text" class="form-control" id="from_person" name="from_person" value="{{ $evidence->custodian }}" required>
                        </div>
                        <div class="form-group">
                            <label for="to_person">To Person</label>
                            <input type="text" class="form-control" id="to_person" name="to_person" required>
                        </div>
                        <div class="form-group">
                            <label for="transfer_date">Transfer Date</label>
                            <input type="date" class="form-control" id="transfer_date" name="transfer_date" value="{{ date('Y-m-d') }}" required>
                        </div>
                        <div class="form-group">
                            <label for="transfer_time">Transfer Time</label>
                            <input type="time" class="form-control" id="transfer_time" name="transfer_time" value="{{ date('H:i') }}" required>
                        </div>
                        <div class="form-group">
                            <label for="reason">Reason for Transfer</label>
                            <select class="form-control" id="reason" name="reason" required>
                                <option value="">-- Select Reason --</option>
                                <option value="analysis">For Analysis</option>
                                <option value="storage">For Storage</option>
                                <option value="court">For Court Proceedings</option>
                                <option value="return">Return to Owner</option>
                                <option value="disposal">For Disposal</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="notes">Notes</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Record Transfer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
    <style>
        .bg-light {
            background-color: #f8f9fa;
        }
        .timeline {
            margin: 0;
            padding: 0;
            position: relative;
        }
    </style>
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Any additional JS can go here
        });
    </script>
@stop
