@extends('adminlte::page')

@section('title', 'Generate Case Report')

@section('content_header')
    <h1>Generate Case Report</h1>
@stop

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Report Options</h3>
            </div>
            <form action="{{ route('case-reports.generate') }}" method="POST">
                @csrf
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="form-group">
                        <label for="case_id">Select Case</label>
                        <select name="case_id" id="case_id" class="form-control select2 @error('case_id') is-invalid @enderror" required>
                            <option value="">-- Select a Case --</option>
                            @foreach($cases as $case)
                                <option value="{{ $case->id }}" {{ (old('case_id', $selectedCaseId) == $case->id) ? 'selected' : '' }}>
                                    #{{ $case->case_number }} - {{ $case->title }} 
                                    ({{ $case->station->name ?? 'Unknown Station' }})
                                </option>
                            @endforeach
                        </select>
                        @error('case_id')
                            <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label>Report Type</label>
                        <div class="d-flex">
                            <div class="custom-control custom-radio mr-4">
                                <input class="custom-control-input" type="radio" id="report_type_detailed" name="report_type" value="detailed" checked>
                                <label for="report_type_detailed" class="custom-control-label">Detailed Report</label>
                            </div>
                            <div class="custom-control custom-radio">
                                <input class="custom-control-input" type="radio" id="report_type_summary" name="report_type" value="summary">
                                <label for="report_type_summary" class="custom-control-label">Summary Report</label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Output Format</label>
                        <div class="d-flex">
                            <div class="custom-control custom-radio mr-4">
                                <input class="custom-control-input" type="radio" id="output_format_html" name="output_format" value="html" checked>
                                <label for="output_format_html" class="custom-control-label">View Online (HTML)</label>
                            </div>
                            <div class="custom-control custom-radio">
                                <input class="custom-control-input" type="radio" id="output_format_pdf" name="output_format" value="pdf">
                                <label for="output_format_pdf" class="custom-control-label">Download (PDF)</label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Include Sections</label>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="custom-control custom-checkbox">
                                    <input class="custom-control-input" type="checkbox" id="include_case_details" name="include_sections[]" value="case_details" checked>
                                    <label for="include_case_details" class="custom-control-label">Case Details</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="custom-control custom-checkbox">
                                    <input class="custom-control-input" type="checkbox" id="include_victims" name="include_sections[]" value="victims" checked>
                                    <label for="include_victims" class="custom-control-label">Victims</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="custom-control custom-checkbox">
                                    <input class="custom-control-input" type="checkbox" id="include_suspects" name="include_sections[]" value="suspects" checked>
                                    <label for="include_suspects" class="custom-control-label">Suspects</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="custom-control custom-checkbox">
                                    <input class="custom-control-input" type="checkbox" id="include_statements" name="include_sections[]" value="statements" checked>
                                    <label for="include_statements" class="custom-control-label">Statements</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-md-3">
                                <div class="custom-control custom-checkbox">
                                    <input class="custom-control-input" type="checkbox" id="include_evidence" name="include_sections[]" value="evidence" checked>
                                    <label for="include_evidence" class="custom-control-label">Evidence</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="custom-control custom-checkbox">
                                    <input class="custom-control-input" type="checkbox" id="include_updates" name="include_sections[]" value="updates" checked>
                                    <label for="include_updates" class="custom-control-label">Case Updates</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="custom-control custom-checkbox">
                                    <input class="custom-control-input" type="checkbox" id="include_officers" name="include_sections[]" value="officers" checked>
                                    <label for="include_officers" class="custom-control-label">Officers Involved</label>
                                </div>
                            </div>
                        </div>
                        @error('include_sections')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-file-alt mr-1"></i> Generate Report
                    </button>
                    <a href="{{ route('cases.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left mr-1"></i> Back to Cases
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.5.2/dist/select2-bootstrap4.min.css">
@stop

@section('js')
    <!-- Select2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                theme: 'bootstrap4',
                width: '100%'
            });
        });
    </script>
@stop
