@extends('adminlte::page')

@section('title', 'Record New Statement')

@section('content_header')
    <h1>Record New Statement</h1>
@stop

@section('content')
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('case-statements.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="case_id">Case <span class="text-danger">*</span></label>
                            <select class="form-control @error('case_id') is-invalid @enderror" id="case_id" name="case_id" required>
                                <option value="">-- Select Case --</option>
                                @foreach($cases as $case)
                                    <option value="{{ $case->id }}" {{ (old('case_id') == $case->id || (isset($preselectedCase) && $preselectedCase->id == $case->id)) ? 'selected' : '' }}>
                                        #{{ $case->case_number }} - {{ $case->title }}
                                    </option>
                                @endforeach
                            </select>
                            @error('case_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="statement_type">Statement Type <span class="text-danger">*</span></label>
                            <select class="form-control @error('statement_type') is-invalid @enderror" id="statement_type" name="statement_type" required>
                                <option value="">-- Select Type --</option>
                                <option value="victim" {{ old('statement_type') == 'victim' ? 'selected' : '' }}>Victim</option>
                                <option value="witness" {{ old('statement_type') == 'witness' ? 'selected' : '' }}>Witness</option>
                                <option value="suspect" {{ old('statement_type') == 'suspect' ? 'selected' : '' }}>Suspect</option>
                                <option value="expert" {{ old('statement_type') == 'expert' ? 'selected' : '' }}>Expert</option>
                                <option value="officer" {{ old('statement_type') == 'officer' ? 'selected' : '' }}>Officer</option>
                            </select>
                            @error('statement_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <h4 class="mt-4">Person Information</h4>
                <hr>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="given_by_name">Full Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('given_by_name') is-invalid @enderror" id="given_by_name" name="given_by_name" value="{{ old('given_by_name') }}" required>
                            @error('given_by_name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="given_by_contact">Contact Number</label>
                            <input type="text" class="form-control @error('given_by_contact') is-invalid @enderror" id="given_by_contact" name="given_by_contact" value="{{ old('given_by_contact') }}">
                            @error('given_by_contact')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="given_by_address">Address</label>
                            <textarea class="form-control @error('given_by_address') is-invalid @enderror" id="given_by_address" name="given_by_address" rows="2">{{ old('given_by_address') }}</textarea>
                            @error('given_by_address')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="given_by_id_type">ID Type</label>
                            <select class="form-control @error('given_by_id_type') is-invalid @enderror" id="given_by_id_type" name="given_by_id_type">
                                <option value="">-- Select ID Type --</option>
                                <option value="national_id" {{ old('given_by_id_type') == 'national_id' ? 'selected' : '' }}>National ID</option>
                                <option value="passport" {{ old('given_by_id_type') == 'passport' ? 'selected' : '' }}>Passport</option>
                                <option value="drivers_license" {{ old('given_by_id_type') == 'drivers_license' ? 'selected' : '' }}>Driver's License</option>
                                <option value="voter_card" {{ old('given_by_id_type') == 'voter_card' ? 'selected' : '' }}>Voter's Card</option>
                                <option value="other" {{ old('given_by_id_type') == 'other' ? 'selected' : '' }}>Other</option>
                            </select>
                            @error('given_by_id_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="given_by_id_number">ID Number</label>
                            <input type="text" class="form-control @error('given_by_id_number') is-invalid @enderror" id="given_by_id_number" name="given_by_id_number" value="{{ old('given_by_id_number') }}">
                            @error('given_by_id_number')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <h4 class="mt-4">Statement Details</h4>
                <hr>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="recorded_by_officer_id">Recorded By Officer <span class="text-danger">*</span></label>
                            <select class="form-control @error('recorded_by_officer_id') is-invalid @enderror" id="recorded_by_officer_id" name="recorded_by_officer_id" required>
                                <option value="">-- Select Officer --</option>
                                @foreach($officers as $officer)
                                    <option value="{{ $officer->id }}" {{ old('recorded_by_officer_id', Auth::id()) == $officer->id ? 'selected' : '' }}>
                                        {{ $officer->rank }} {{ $officer->name }} ({{ $officer->badge_number ?? 'No Badge' }})
                                    </option>
                                @endforeach
                            </select>
                            @error('recorded_by_officer_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="statement_date">Statement Date <span class="text-danger">*</span></label>
                            <input type="datetime-local" class="form-control @error('statement_date') is-invalid @enderror" id="statement_date" name="statement_date" value="{{ old('statement_date', now()->format('Y-m-d\TH:i')) }}" required>
                            @error('statement_date')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="location_taken">Location Taken</label>
                            <input type="text" class="form-control @error('location_taken') is-invalid @enderror" id="location_taken" name="location_taken" value="{{ old('location_taken') }}">
                            @error('location_taken')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="language_used">Language Used</label>
                            <input type="text" class="form-control @error('language_used') is-invalid @enderror" id="language_used" name="language_used" value="{{ old('language_used', 'English') }}">
                            @error('language_used')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="statement_content">Statement Content <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('statement_content') is-invalid @enderror" id="statement_content" name="statement_content" rows="10" required>{{ old('statement_content') }}</textarea>
                            @error('statement_content')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="signature">Signature</label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('signature') is-invalid @enderror" id="signature" name="signature">
                                    <label class="custom-file-label" for="signature">Choose file</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Accepted formats: JPG, PNG. Max size: 2MB</small>
                            @error('signature')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="audio_recording">Audio Recording</label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('audio_recording') is-invalid @enderror" id="audio_recording" name="audio_recording">
                                    <label class="custom-file-label" for="audio_recording">Choose file</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Accepted formats: MP3, WAV. Max size: 10MB</small>
                            @error('audio_recording')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="is_sworn" name="is_sworn" value="1" {{ old('is_sworn') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_sworn">Statement was given under oath</label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-12">
                        <a href="{{ url()->previous() }}" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary float-right">Record Statement</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Update file input label with selected filename
            $('.custom-file-input').on('change', function() {
                let fileName = $(this).val().split('\\').pop();
                $(this).next('.custom-file-label').addClass("selected").html(fileName);
            });
        });
    </script>
@stop
