@extends('adminlte::page')

@section('title', 'View Statement')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Statement Details</h1>
        <div>
            <a href="{{ route('case-statements.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Statements
            </a>
            @if(!$statement->is_verified && (Auth::user()->is_admin || Auth::id() != $statement->recorded_by_officer_id))
                <a href="{{ route('case-statements.edit', $statement->id) }}#verify" class="btn btn-success">
                    <i class="fas fa-check"></i> Verify Statement
                </a>
            @endif
            <a href="{{ route('case-statements.edit', $statement->id) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal">
                <i class="fas fa-trash"></i> Delete
            </button>
        </div>
    </div>
@stop

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Statement Information</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Case</label>
                                <p>
                                    <a href="{{ route('cases.show', $statement->case_id) }}">
                                        #{{ $statement->case->case_number }} - {{ $statement->case->title }}
                                    </a>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Statement Type</label>
                                <p>
                                    @switch($statement->statement_type)
                                        @case('victim')
                                            <span class="badge badge-danger">Victim</span>
                                            @break
                                        @case('witness')
                                            <span class="badge badge-info">Witness</span>
                                            @break
                                        @case('suspect')
                                            <span class="badge badge-warning">Suspect</span>
                                            @break
                                        @case('expert')
                                            <span class="badge badge-primary">Expert</span>
                                            @break
                                        @case('officer')
                                            <span class="badge badge-success">Officer</span>
                                            @break
                                        @default
                                            <span class="badge badge-secondary">{{ ucfirst($statement->statement_type) }}</span>
                                    @endswitch
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Statement Date</label>
                                <p>{{ $statement->statement_date->format('d M Y, h:i A') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Location Taken</label>
                                <p>{{ $statement->location_taken ?? 'Not specified' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Language Used</label>
                                <p>{{ $statement->language_used ?? 'Not specified' }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Given Under Oath</label>
                                <p>
                                    @if($statement->is_sworn)
                                        <span class="badge badge-success">Yes</span>
                                    @else
                                        <span class="badge badge-secondary">No</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Recorded By</label>
                                <p>{{ $statement->recordedByOfficer->rank }} {{ $statement->recordedByOfficer->name }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Verification Status</label>
                                <p>
                                    @if($statement->is_verified)
                                        <span class="badge badge-success">Verified</span>
                                        @if($statement->verified_by_officer_id)
                                            by {{ $statement->verifiedByOfficer->name }} on {{ $statement->verified_at->format('d M Y') }}
                                        @endif
                                    @else
                                        <span class="badge badge-secondary">Not Verified</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Statement Content</label>
                                <div class="p-3 bg-light" style="border-radius: 5px; white-space: pre-wrap;">{{ $statement->statement_content }}</div>
                            </div>
                        </div>
                    </div>
                    
                    @if($statement->verification_notes)
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Verification Notes</label>
                                    <div class="p-3 bg-light" style="border-radius: 5px;">{{ $statement->verification_notes }}</div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Person Information</h3>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Full Name</label>
                        <p>{{ $statement->given_by_name }}</p>
                    </div>
                    
                    <div class="form-group">
                        <label>Contact Number</label>
                        <p>{{ $statement->given_by_contact ?? 'Not provided' }}</p>
                    </div>
                    
                    <div class="form-group">
                        <label>Address</label>
                        <p>{{ $statement->given_by_address ?? 'Not provided' }}</p>
                    </div>
                    
                    <div class="form-group">
                        <label>ID Information</label>
                        @if($statement->given_by_id_type && $statement->given_by_id_number)
                            <p>{{ ucfirst(str_replace('_', ' ', $statement->given_by_id_type)) }}: {{ $statement->given_by_id_number }}</p>
                        @else
                            <p>Not provided</p>
                        @endif
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Attachments</h3>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Signature</label>
                        @if($statement->signature_path)
                            <div>
                                <img src="{{ asset('storage/' . $statement->signature_path) }}" alt="Signature" class="img-fluid img-thumbnail">
                            </div>
                        @else
                            <p>No signature provided</p>
                        @endif
                    </div>
                    
                    <div class="form-group">
                        <label>Audio Recording</label>
                        @if($statement->audio_path)
                            <div>
                                <audio controls class="w-100">
                                    <source src="{{ asset('storage/' . $statement->audio_path) }}" type="audio/mpeg">
                                    Your browser does not support the audio element.
                                </audio>
                                <a href="{{ route('case-statements.download-audio', $statement->id) }}" class="btn btn-sm btn-primary mt-2">
                                    <i class="fas fa-download"></i> Download Audio
                                </a>
                            </div>
                        @else
                            <p>No audio recording provided</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Delete Statement</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this statement from <strong>{{ $statement->given_by_name }}</strong>?
                    <p class="text-danger mt-2">This action cannot be undone and will permanently delete all associated files.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <form action="{{ route('case-statements.destroy', $statement->id) }}" method="POST" style="display: inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Delete Statement</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
    <style>
        .bg-light {
            background-color: #f8f9fa;
        }
    </style>
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Any additional JS can go here
        });
    </script>
@stop
