@extends('adminlte::page')

@section('title', 'Cases by Crime Type')

@section('content_header')
    <h1>Cases by Crime Type</h1>
@stop

@section('content')
<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-chart-pie mr-1"></i>
                    Distribution by Crime Type
                </h3>
            </div>
            <div class="card-body">
                <canvas id="crimeTypeDistributionChart" height="300"></canvas>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-table mr-1"></i>
                    Crime Type Statistics
                </h3>
            </div>
            <div class="card-body p-0">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Crime Type</th>
                            <th>Total Cases</th>
                            <th>Percentage</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $totalCases = array_sum($casesByCrimeType);
                        @endphp
                        
                        @foreach($casesByCrimeType as $crimeType => $count)
                            <tr>
                                <td>{{ $crimeTypes[$crimeType] ?? ucfirst(str_replace('_', ' ', $crimeType)) }}</td>
                                <td>
                                    <span class="badge badge-primary">{{ $count }}</span>
                                </td>
                                <td>
                                    {{ number_format(($count / $totalCases) * 100, 1) }}%
                                </td>
                                <td>
                                    <a href="{{ route('cases.index', ['crime_type' => $crimeType]) }}" class="btn btn-xs btn-info">
                                        <i class="fas fa-eye"></i> View Cases
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-chart-line mr-1"></i>
                    Crime Type Trends (Last 12 Months)
                </h3>
            </div>
            <div class="card-body">
                <canvas id="crimeTypeTrendsChart" height="300"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-table mr-1"></i>
                    Crime Type Status Breakdown
                </h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Crime Type</th>
                                <th>Total</th>
                                <th>Open</th>
                                <th>Under Investigation</th>
                                <th>Pending Review</th>
                                <th>Closed</th>
                                <th>Other</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($casesByCrimeType as $crimeType => $count)
                                <tr>
                                    <td>{{ $crimeTypes[$crimeType] ?? ucfirst(str_replace('_', ' ', $crimeType)) }}</td>
                                    <td>
                                        <span class="badge badge-primary">{{ $count }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $openCount = 0;
                                            if (isset($crimeTypeStatusBreakdown[$crimeType])) {
                                                foreach ($crimeTypeStatusBreakdown[$crimeType] as $breakdown) {
                                                    if ($breakdown->status === 'open') {
                                                        $openCount = $breakdown->total;
                                                        break;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <span class="badge badge-success">{{ $openCount }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $underInvestigationCount = 0;
                                            if (isset($crimeTypeStatusBreakdown[$crimeType])) {
                                                foreach ($crimeTypeStatusBreakdown[$crimeType] as $breakdown) {
                                                    if ($breakdown->status === 'under_investigation') {
                                                        $underInvestigationCount = $breakdown->total;
                                                        break;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <span class="badge badge-info">{{ $underInvestigationCount }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $pendingReviewCount = 0;
                                            if (isset($crimeTypeStatusBreakdown[$crimeType])) {
                                                foreach ($crimeTypeStatusBreakdown[$crimeType] as $breakdown) {
                                                    if ($breakdown->status === 'pending_review') {
                                                        $pendingReviewCount = $breakdown->total;
                                                        break;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <span class="badge badge-warning">{{ $pendingReviewCount }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $closedCount = 0;
                                            if (isset($crimeTypeStatusBreakdown[$crimeType])) {
                                                foreach ($crimeTypeStatusBreakdown[$crimeType] as $breakdown) {
                                                    if ($breakdown->status === 'closed') {
                                                        $closedCount = $breakdown->total;
                                                        break;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <span class="badge badge-secondary">{{ $closedCount }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $otherCount = 0;
                                            if (isset($crimeTypeStatusBreakdown[$crimeType])) {
                                                foreach ($crimeTypeStatusBreakdown[$crimeType] as $breakdown) {
                                                    if (!in_array($breakdown->status, ['open', 'under_investigation', 'pending_review', 'closed'])) {
                                                        $otherCount += $breakdown->total;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <span class="badge badge-dark">{{ $otherCount }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-exclamation-triangle mr-1"></i>
                    Crime Type by Priority
                </h3>
            </div>
            <div class="card-body">
                <div class="row">
                    @foreach($crimeTypesByPriority->take(6) as $crimeType => $priorityData)
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="card-title">{{ $crimeTypes[$crimeType] ?? ucfirst(str_replace('_', ' ', $crimeType)) }}</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="crimeTypePriorityChart{{ str_replace(' ', '', $crimeType) }}" height="200"></canvas>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
    <script>
        $(document).ready(function() {
            // Crime Type Distribution Chart
            const crimeTypeLabels = [];
            const crimeTypeData = [];
            const crimeTypeColors = [
                'rgba(255, 99, 132, 0.7)',
                'rgba(54, 162, 235, 0.7)',
                'rgba(255, 206, 86, 0.7)',
                'rgba(75, 192, 192, 0.7)',
                'rgba(153, 102, 255, 0.7)',
                'rgba(255, 159, 64, 0.7)',
                'rgba(199, 199, 199, 0.7)',
                'rgba(83, 102, 255, 0.7)',
                'rgba(40, 159, 64, 0.7)',
                'rgba(210, 199, 199, 0.7)',
                'rgba(78, 52, 199, 0.7)'
            ];
            
            const crimeTypes = @json($crimeTypes);
            const casesByCrimeType = @json($casesByCrimeType);
            
            let i = 0;
            for (const [key, value] of Object.entries(casesByCrimeType)) {
                crimeTypeLabels.push(crimeTypes[key] || key);
                crimeTypeData.push(value);
                i++;
            }
            
            const crimeTypeCtx = document.getElementById('crimeTypeDistributionChart').getContext('2d');
            new Chart(crimeTypeCtx, {
                type: 'pie',
                data: {
                    labels: crimeTypeLabels,
                    datasets: [{
                        data: crimeTypeData,
                        backgroundColor: crimeTypeColors,
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'right',
                        }
                    }
                }
            });
            
            // Crime Type Trends Chart
            const crimeTypesByMonth = @json($crimeTypesByMonth);
            const monthNames = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
            const datasets = [];
            const colors = crimeTypeColors;
            
            // Get all unique months from the data
            const allMonths = new Set();
            for (const [crimeType, monthData] of Object.entries(crimeTypesByMonth)) {
                for (const data of monthData) {
                    allMonths.add(`${data.year}-${data.month}`);
                }
            }
            
            // Sort months chronologically
            const sortedMonths = Array.from(allMonths).sort();
            const labels = sortedMonths.map(month => {
                const [year, monthNum] = month.split('-');
                return `${monthNames[parseInt(monthNum) - 1]} ${year}`;
            });
            
            // Create datasets for each crime type
            let colorIndex = 0;
            for (const [crimeType, monthData] of Object.entries(crimeTypesByMonth)) {
                const dataPoints = {};
                
                // Initialize all months with 0
                for (const month of sortedMonths) {
                    dataPoints[month] = 0;
                }
                
                // Fill in actual data
                for (const data of monthData) {
                    const monthKey = `${data.year}-${data.month}`;
                    dataPoints[monthKey] = data.total;
                }
                
                // Convert to array in correct order
                const values = sortedMonths.map(month => dataPoints[month]);
                
                datasets.push({
                    label: crimeTypes[crimeType] || crimeType,
                    data: values,
                    borderColor: colors[colorIndex % colors.length],
                    backgroundColor: colors[colorIndex % colors.length].replace('0.7', '0.1'),
                    borderWidth: 2,
                    fill: false,
                    tension: 0.1
                });
                
                colorIndex++;
            }
            
            const trendsCtx = document.getElementById('crimeTypeTrendsChart').getContext('2d');
            new Chart(trendsCtx, {
                type: 'line',
                data: {
                    labels: labels,
                    datasets: datasets
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            });
            
            // Crime Type Priority Charts
            const priorityLabels = {
                'low': 'Low',
                'medium': 'Medium',
                'high': 'High',
                'critical': 'Critical'
            };
            
            const priorityColors = {
                'low': '#17a2b8',
                'medium': '#007bff',
                'high': '#ffc107',
                'critical': '#dc3545'
            };
            
            const crimeTypesByPriority = @json($crimeTypesByPriority);
            
            for (const [crimeType, priorityData] of Object.entries(crimeTypesByPriority)) {
                const chartId = `crimeTypePriorityChart${crimeType.replace(/\s+/g, '')}`;
                const chartElement = document.getElementById(chartId);
                
                if (!chartElement) continue;
                
                const priorityLabelsArray = [];
                const priorityDataArray = [];
                const priorityColorsArray = [];
                
                for (const data of priorityData) {
                    priorityLabelsArray.push(priorityLabels[data.priority] || data.priority);
                    priorityDataArray.push(data.total);
                    priorityColorsArray.push(priorityColors[data.priority] || '#6c757d');
                }
                
                const ctx = chartElement.getContext('2d');
                new Chart(ctx, {
                    type: 'doughnut',
                    data: {
                        labels: priorityLabelsArray,
                        datasets: [{
                            data: priorityDataArray,
                            backgroundColor: priorityColorsArray,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            legend: {
                                position: 'bottom',
                                labels: {
                                    boxWidth: 12
                                }
                            },
                            title: {
                                display: true,
                                text: 'Priority Distribution'
                            }
                        }
                    }
                });
            }
        });
    </script>
@stop
