@extends('adminlte::page')

@section('title', 'Cases by Officer')

@section('content_header')
    <h1>Cases by Officer</h1>
@stop

@section('content')
<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-user-tie mr-1"></i>
                    Top Lead Investigators
                </h3>
            </div>
            <div class="card-body">
                <canvas id="topInvestigatorsChart" height="300"></canvas>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-user-shield mr-1"></i>
                    Top Reporting Officers
                </h3>
            </div>
            <div class="card-body">
                <canvas id="topReportingOfficersChart" height="300"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-chart-pie mr-1"></i>
                    Case Status Distribution by Top Investigators
                </h3>
            </div>
            <div class="card-body">
                <div class="row">
                    @foreach($investigatorCaseStatusBreakdown as $officerId => $data)
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="card-title">{{ $data['name'] }}</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="officerStatusChart{{ $officerId }}" height="200"></canvas>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-table mr-1"></i>
                    Officer Case Workload
                </h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Officer Name</th>
                                <th>Rank</th>
                                <th>Badge Number</th>
                                <th>Lead Investigator Cases</th>
                                <th>Reporting Officer Cases</th>
                                <th>Total Cases</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($officersWithCases as $officer)
                                <tr>
                                    <td>{{ $officer->name }}</td>
                                    <td>{{ $officer->rank ?? 'N/A' }}</td>
                                    <td>{{ $officer->badge_number ?? 'N/A' }}</td>
                                    <td>
                                        <span class="badge badge-primary">{{ $officer->lead_cases_count }}</span>
                                    </td>
                                    <td>
                                        <span class="badge badge-info">{{ $officer->reporting_cases_count }}</span>
                                    </td>
                                    <td>
                                        <span class="badge badge-success">{{ $officer->lead_cases_count + $officer->reporting_cases_count }}</span>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('cases.index', ['lead_investigator_id' => $officer->id]) }}" class="btn btn-xs btn-primary">
                                                <i class="fas fa-search"></i> Lead Cases
                                            </a>
                                            <a href="{{ route('cases.index', ['reporting_officer_id' => $officer->id]) }}" class="btn btn-xs btn-info">
                                                <i class="fas fa-search"></i> Reported Cases
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
    <script>
        $(document).ready(function() {
            // Top Investigators Chart
            const investigatorData = @json($topInvestigators);
            const investigatorLabels = investigatorData.map(officer => officer.name);
            const investigatorCounts = investigatorData.map(officer => officer.cases_count);
            
            const investigatorCtx = document.getElementById('topInvestigatorsChart').getContext('2d');
            new Chart(investigatorCtx, {
                type: 'bar',
                data: {
                    labels: investigatorLabels,
                    datasets: [{
                        label: 'Cases as Lead Investigator',
                        data: investigatorCounts,
                        backgroundColor: 'rgba(40, 167, 69, 0.5)',
                        borderColor: 'rgba(40, 167, 69, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    indexAxis: 'y',
                    responsive: true,
                    scales: {
                        x: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            });
            
            // Top Reporting Officers Chart
            const reportingOfficerData = @json($topReportingOfficers);
            const reportingOfficerLabels = reportingOfficerData.map(officer => officer.name);
            const reportingOfficerCounts = reportingOfficerData.map(officer => officer.cases_count);
            
            const reportingOfficerCtx = document.getElementById('topReportingOfficersChart').getContext('2d');
            new Chart(reportingOfficerCtx, {
                type: 'bar',
                data: {
                    labels: reportingOfficerLabels,
                    datasets: [{
                        label: 'Cases as Reporting Officer',
                        data: reportingOfficerCounts,
                        backgroundColor: 'rgba(0, 123, 255, 0.5)',
                        borderColor: 'rgba(0, 123, 255, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    indexAxis: 'y',
                    responsive: true,
                    scales: {
                        x: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            });
            
            // Officer Status Charts
            const statusLabels = {
                'open': 'Open',
                'under_investigation': 'Under Investigation',
                'pending_review': 'Pending Review',
                'closed': 'Closed',
                'reopened': 'Reopened',
                'archived': 'Archived'
            };
            
            const statusColors = {
                'open': '#28a745',
                'under_investigation': '#007bff',
                'pending_review': '#ffc107',
                'closed': '#6c757d',
                'reopened': '#17a2b8',
                'archived': '#343a40'
            };
            
            const officerStatusBreakdown = @json($investigatorCaseStatusBreakdown);
            
            for (const [officerId, data] of Object.entries(officerStatusBreakdown)) {
                const breakdown = data.breakdown;
                const statusLabelsArray = [];
                const statusDataArray = [];
                const statusColorsArray = [];
                
                for (const [key, value] of Object.entries(breakdown)) {
                    statusLabelsArray.push(statusLabels[key] || key);
                    statusDataArray.push(value);
                    statusColorsArray.push(statusColors[key] || '#6c757d');
                }
                
                const officerStatusCtx = document.getElementById(`officerStatusChart${officerId}`).getContext('2d');
                new Chart(officerStatusCtx, {
                    type: 'doughnut',
                    data: {
                        labels: statusLabelsArray,
                        datasets: [{
                            data: statusDataArray,
                            backgroundColor: statusColorsArray,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            legend: {
                                position: 'bottom',
                                labels: {
                                    boxWidth: 12
                                }
                            },
                            title: {
                                display: true,
                                text: 'Case Status Distribution'
                            }
                        }
                    }
                });
            }
        });
    </script>
@stop
