@extends('adminlte::page')

@section('title', 'Cases by Station')

@section('content_header')
    <h1>Cases by Police Station</h1>
@stop

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-chart-bar mr-1"></i>
                    Case Distribution by Station
                </h3>
            </div>
            <div class="card-body">
                <canvas id="casesByStationChart" height="300"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-building mr-1"></i>
                    Stations with Most Cases
                </h3>
            </div>
            <div class="card-body p-0">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Station</th>
                            <th>Total Cases</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($stationsWithMostCases as $station)
                            <tr>
                                <td>{{ $station->name }}</td>
                                <td>
                                    <span class="badge badge-primary">{{ $station->cases_count }}</span>
                                </td>
                                <td>
                                    <a href="{{ route('cases.index', ['station_id' => $station->id]) }}" class="btn btn-xs btn-info">
                                        <i class="fas fa-eye"></i> View Cases
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-folder-open mr-1"></i>
                    Stations with Most Open Cases
                </h3>
            </div>
            <div class="card-body p-0">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Station</th>
                            <th>Open Cases</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($stationsWithMostOpenCases as $station)
                            <tr>
                                <td>{{ $station->name }}</td>
                                <td>
                                    <span class="badge badge-success">{{ $station->cases_count }}</span>
                                </td>
                                <td>
                                    <a href="{{ route('cases.index', ['station_id' => $station->id, 'status' => 'open,under_investigation,pending_review']) }}" class="btn btn-xs btn-info">
                                        <i class="fas fa-eye"></i> View Cases
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-table mr-1"></i>
                    Detailed Station Case Breakdown
                </h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Station</th>
                                <th>Total Cases</th>
                                <th>Open</th>
                                <th>Under Investigation</th>
                                <th>Pending Review</th>
                                <th>Closed</th>
                                <th>Other</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($stations as $station)
                                <tr>
                                    <td>{{ $station->name }}</td>
                                    <td>
                                        <span class="badge badge-primary">{{ $station->cases_count }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $openCount = 0;
                                            if (isset($stationStatusBreakdown[$station->id])) {
                                                foreach ($stationStatusBreakdown[$station->id] as $breakdown) {
                                                    if ($breakdown->status === 'open') {
                                                        $openCount = $breakdown->total;
                                                        break;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <span class="badge badge-success">{{ $openCount }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $underInvestigationCount = 0;
                                            if (isset($stationStatusBreakdown[$station->id])) {
                                                foreach ($stationStatusBreakdown[$station->id] as $breakdown) {
                                                    if ($breakdown->status === 'under_investigation') {
                                                        $underInvestigationCount = $breakdown->total;
                                                        break;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <span class="badge badge-info">{{ $underInvestigationCount }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $pendingReviewCount = 0;
                                            if (isset($stationStatusBreakdown[$station->id])) {
                                                foreach ($stationStatusBreakdown[$station->id] as $breakdown) {
                                                    if ($breakdown->status === 'pending_review') {
                                                        $pendingReviewCount = $breakdown->total;
                                                        break;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <span class="badge badge-warning">{{ $pendingReviewCount }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $closedCount = 0;
                                            if (isset($stationStatusBreakdown[$station->id])) {
                                                foreach ($stationStatusBreakdown[$station->id] as $breakdown) {
                                                    if ($breakdown->status === 'closed') {
                                                        $closedCount = $breakdown->total;
                                                        break;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <span class="badge badge-secondary">{{ $closedCount }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $otherCount = 0;
                                            if (isset($stationStatusBreakdown[$station->id])) {
                                                foreach ($stationStatusBreakdown[$station->id] as $breakdown) {
                                                    if (!in_array($breakdown->status, ['open', 'under_investigation', 'pending_review', 'closed'])) {
                                                        $otherCount += $breakdown->total;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <span class="badge badge-dark">{{ $otherCount }}</span>
                                    </td>
                                    <td>
                                        <a href="{{ route('cases.index', ['station_id' => $station->id]) }}" class="btn btn-xs btn-info">
                                            <i class="fas fa-eye"></i> View Cases
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
    <script>
        $(document).ready(function() {
            // Cases by Station Chart
            const stationData = @json($stations);
            const stationLabels = stationData.map(station => station.name);
            const stationCounts = stationData.map(station => station.cases_count);
            
            const stationCtx = document.getElementById('casesByStationChart').getContext('2d');
            new Chart(stationCtx, {
                type: 'bar',
                data: {
                    labels: stationLabels,
                    datasets: [{
                        label: 'Total Cases',
                        data: stationCounts,
                        backgroundColor: 'rgba(0, 123, 255, 0.5)',
                        borderColor: 'rgba(0, 123, 255, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            });
        });
    </script>
@stop
